/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.mysql.generator;

import cn.com.duiba.mysql.generator.entity.GeneratorConfig;
import cn.com.duiba.mysql.generator.entity.TableEntity;
import cn.com.duiba.mysql.generator.exceptions.DuibaGeneratorException;
import cn.com.duiba.mysql.generator.gencode.JavaDaoGenerator;
import cn.com.duiba.mysql.generator.gencode.JavaDaoImplGenerator;
import cn.com.duiba.mysql.generator.gencode.JavaEntityGenerator;
import cn.com.duiba.mysql.generator.gencode.SQLXmlGenerator;
import cn.com.duiba.mysql.generator.service.DuibaFreemarkerService;
import cn.com.duiba.mysql.generator.utils.DBUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class MybatisGenerator {
    public static void genCode(GeneratorConfig config) {
        MybatisGenerator.check(config);
        DuibaFreemarkerService freemarkerService = new DuibaFreemarkerService();
        TableEntity tableEntity = null;
        try {
            tableEntity = DBUtils.getTableInfo(config);
        }
        catch (SQLException e) {
            throw new DuibaGeneratorException(e);
        }
        JavaEntityGenerator doGenerator = new JavaEntityGenerator(freemarkerService, tableEntity, config);
        doGenerator.gen();
        JavaDaoGenerator daoGenerator = new JavaDaoGenerator(freemarkerService, tableEntity, config);
        daoGenerator.gen();
        JavaDaoImplGenerator daoImplGenerator = new JavaDaoImplGenerator(freemarkerService, tableEntity, config);
        daoImplGenerator.gen();
        SQLXmlGenerator sqlXmlGenerator = new SQLXmlGenerator(freemarkerService, tableEntity, config);
        sqlXmlGenerator.gen();
    }

    private static void check(GeneratorConfig config) {
        if (config == null) {
            throw new DuibaGeneratorException("\u751f\u6210\u4ee3\u7801\u524d\u8bf7\u8bbe\u7f6e");
        }
        config.check();
    }

    public static Connection getConnection(String url, String user, String pwd) {
        Connection connection = null;
        try {
            Class.forName("com.mysql.jdbc.Driver");
            connection = DriverManager.getConnection(url, user, pwd);
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new DuibaGeneratorException(e);
        }
        return connection;
    }
}

