/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.mysql.generator.gencode;

import cn.com.duiba.mysql.generator.entity.GeneratorConfig;
import cn.com.duiba.mysql.generator.entity.TableEntity;
import cn.com.duiba.mysql.generator.exceptions.DuibaGeneratorException;
import cn.com.duiba.mysql.generator.service.DuibaFreemarkerService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public abstract class AbstractGenerator {
    private DuibaFreemarkerService freemarkerService;
    protected TableEntity tableEntity;
    protected GeneratorConfig config;
    private Map<String, Object> params = new HashMap<String, Object>();

    public AbstractGenerator(DuibaFreemarkerService freemarkerService, TableEntity tableEntity, GeneratorConfig config) {
        this.freemarkerService = freemarkerService;
        this.tableEntity = tableEntity;
        this.config = config;
        this.params.put("table", tableEntity);
        this.params.put("pk", tableEntity.getPk());
        this.params.put("pathName", tableEntity.getClassname().toLowerCase());
        this.params.put("columns", tableEntity.getColumns());
        this.params.put("entityPackage", config.getEntityPackage());
        this.params.put("daoPackage", config.getDaoPackage());
        this.params.put("uks", tableEntity.getUniqueKeyMap());
        this.params.put("pre", "#{");
        this.params.put("end", "}");
    }

    public final void gen() {
        String genStr = this.freemarkerService.merge(this.getFTL(), this.params);
        String fileName = this.genFileName();
        String filePath = this.genFilePath();
        this.writeFile(genStr, filePath, fileName);
    }

    private void writeFile(String content, String dirPath, String fileName) {
        boolean dirs;
        File fp = new File(dirPath);
        if (!fp.exists() && !(dirs = fp.mkdirs())) {
            throw new DuibaGeneratorException(dirPath + " \u6587\u4ef6\u76ee\u5f55\u521b\u5efa\u5931\u8d25");
        }
        String file = dirPath + File.separator + fileName;
        File ff = new File(file);
        if (!ff.exists()) {
            try {
                boolean success = ff.createNewFile();
                if (!success) {
                    throw new DuibaGeneratorException(file + "\u521b\u5efa\u5931\u8d25");
                }
                FileOutputStream fos = new FileOutputStream(file);
                IOUtils.write((String)content, (OutputStream)fos);
                fos.close();
            }
            catch (IOException e) {
                throw new DuibaGeneratorException(file + " error " + e);
            }
        }
    }

    protected abstract String getFTL();

    protected abstract String genFileName();

    protected abstract String genFilePath();
}

