/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.mysql.generator.utils;

import cn.com.duiba.mysql.generator.entity.ColumnEntity;
import cn.com.duiba.mysql.generator.entity.GeneratorConfig;
import cn.com.duiba.mysql.generator.entity.TableEntity;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;

public class DBUtils {
    private static Map<String, String> typeMap = new HashMap<String, String>();

    public static TableEntity getTableInfo(GeneratorConfig config) throws SQLException {
        String tableName = config.getTableName();
        String tableCatalog = config.getTableSchema();
        Connection conn = config.getConnection();
        String getTableSql = "select table_name as tableName, table_comment as comments from information_schema.tables where table_schema = '" + tableCatalog + "' and table_name = '" + tableName + "'";
        QueryRunner qRunner = new QueryRunner();
        TableEntity entity = (TableEntity)qRunner.query(conn, getTableSql, (ResultSetHandler)new BeanHandler(TableEntity.class));
        entity.setTableSchema(config.getTableSchema());
        String className = DBUtils.tableToJava(entity.getTableName(), config.getTablePrefix());
        entity.setClassName(className);
        entity.setClassname(StringUtils.uncapitalize((String)className));
        List<ColumnEntity> columnList = DBUtils.getTableColumns(conn, tableCatalog, tableName);
        entity.setColumns(columnList);
        entity.setMainColumns(DBUtils.getMainColumns(columnList));
        entity.setPk(DBUtils.getPk(columnList, conn, tableCatalog, tableName));
        Map<String, List<ColumnEntity>> maps = DBUtils.getUniqueKeyMap(conn, tableCatalog, tableName, columnList);
        entity.setUniqueKeyMap(maps);
        return entity;
    }

    private static List<ColumnEntity> getMainColumns(List<ColumnEntity> columnList) {
        ArrayList<ColumnEntity> list = new ArrayList<ColumnEntity>();
        for (ColumnEntity columnEntity : columnList) {
            if ("auto_increment".equalsIgnoreCase(columnEntity.getExtra()) || "on update CURRENT_TIMESTAMP".equalsIgnoreCase(columnEntity.getExtra()) || "gmt_create".equalsIgnoreCase(columnEntity.getColumnName())) continue;
            list.add(columnEntity);
        }
        return list;
    }

    private static Map<String, List<ColumnEntity>> handleUniqueName(Map<String, List<ColumnEntity>> uniqueKeyMap) {
        HashMap<String, List<ColumnEntity>> map = new HashMap<String, List<ColumnEntity>>();
        for (Map.Entry<String, List<ColumnEntity>> entry : uniqueKeyMap.entrySet()) {
            StringBuilder builder = new StringBuilder();
            for (ColumnEntity columnEntity : entry.getValue()) {
                builder.append(columnEntity.getAttrName()).append("And");
            }
            String key = builder.substring(0, builder.lastIndexOf("And"));
            map.put(key, entry.getValue());
        }
        return map;
    }

    private static Map<String, List<ColumnEntity>> getUniqueKeyMap(Connection conn, String schemaName, String tableName, List<ColumnEntity> columns) throws SQLException {
        String sql = "select * from information_schema.KEY_COLUMN_USAGE where TABLE_NAME = '" + tableName + "' and TABLE_SCHEMA = '" + schemaName + "' and CONSTRAINT_NAME != 'PRIMARY'";
        QueryRunner queryRunner = new QueryRunner();
        return (Map)queryRunner.query(conn, sql, resultSet -> {
            HashMap map = new HashMap();
            while (resultSet.next()) {
                String keyName = DBUtils.getUkName(resultSet.getString("CONSTRAINT_NAME"));
                ColumnEntity columnEntity = DBUtils.getByColumnName(resultSet.getString("COLUMN_NAME"), columns);
                if (columnEntity == null) continue;
                if (map.containsKey(keyName)) {
                    ((List)map.get(keyName)).add(columnEntity);
                    continue;
                }
                ArrayList<ColumnEntity> columnEntities = new ArrayList<ColumnEntity>();
                columnEntities.add(columnEntity);
                map.put(keyName, columnEntities);
            }
            return map;
        });
    }

    private static ColumnEntity getPk(List<ColumnEntity> list, Connection conn, String schemaName, String tableName) throws SQLException {
        String sql = "select COLUMN_NAME as columnName from information_schema.KEY_COLUMN_USAGE where TABLE_NAME = '" + tableName + "' and TABLE_SCHEMA = '" + schemaName + "' and CONSTRAINT_NAME = 'PRIMARY'";
        QueryRunner queryRunner = new QueryRunner();
        ColumnEntity columnEntity = (ColumnEntity)queryRunner.query(conn, sql, (ResultSetHandler)new BeanHandler(ColumnEntity.class));
        for (ColumnEntity pkColumn : list) {
            if (!pkColumn.getColumnName().equalsIgnoreCase(columnEntity.getColumnName())) continue;
            return pkColumn;
        }
        return null;
    }

    private static List<ColumnEntity> getTableColumns(Connection conn, String schemaName, String tableName) throws SQLException {
        String getColumnSql = "SELECT COLUMN_NAME as columnName,  DATA_TYPE as dataType, COLUMN_COMMENT as comments, extra as extra from information_schema.COLUMNS where TABLE_SCHEMA = '" + schemaName + "' and TABLE_NAME = '" + tableName + "'";
        QueryRunner queryRunner = new QueryRunner();
        List columnEntities = (List)queryRunner.query(conn, getColumnSql, resultSet -> {
            ArrayList<ColumnEntity> list = new ArrayList<ColumnEntity>();
            while (resultSet.next()) {
                ColumnEntity columnEntity = new ColumnEntity();
                columnEntity.setColumnName(resultSet.getString("columnName"));
                columnEntity.setDataType(resultSet.getString("dataType"));
                columnEntity.setComments(resultSet.getString("comments"));
                columnEntity.setExtra(resultSet.getString("extra"));
                String attrName = DBUtils.columnToJava(columnEntity.getColumnName()).replace("uk", "");
                columnEntity.setAttrName(attrName);
                columnEntity.setAttrname(StringUtils.uncapitalize((String)attrName));
                String attrType = typeMap.get(StringUtils.lowerCase((String)columnEntity.getDataType()));
                columnEntity.setAttrType(attrType);
                list.add(columnEntity);
            }
            return list;
        });
        return columnEntities;
    }

    private static String columnToJava(String columnName) {
        return WordUtils.capitalizeFully((String)columnName, (char[])new char[]{'_'}).replace("_", "");
    }

    private static String tableToJava(String tableName, String tablePrefix) {
        if (StringUtils.isNotBlank((String)tablePrefix)) {
            tableName = tableName.replace(tablePrefix, "");
        }
        return DBUtils.columnToJava(tableName);
    }

    private static ColumnEntity getByColumnName(String columnName, List<ColumnEntity> columns) {
        for (ColumnEntity columnEntity : columns) {
            if (!columnEntity.getColumnName().equalsIgnoreCase(columnName)) continue;
            return columnEntity;
        }
        return null;
    }

    private static String getUkName(String name) {
        return DBUtils.columnToJava(name.replace("uk", "_"));
    }

    static {
        typeMap.put("tinyint", "Integer");
        typeMap.put("smallint", "Integer");
        typeMap.put("mediumint", "Integer");
        typeMap.put("int", "Integer");
        typeMap.put("integer", "Integer");
        typeMap.put("bigint", "Long");
        typeMap.put("bigint unsigned", "Long");
        typeMap.put("float", "Float");
        typeMap.put("double", "Double");
        typeMap.put("decimal", "BigDecimal");
        typeMap.put("char", "String");
        typeMap.put("varchar", "String");
        typeMap.put("tinytext", "String");
        typeMap.put("text", "String");
        typeMap.put("mediumtext", "String");
        typeMap.put("longtext", "String");
        typeMap.put("date", "Date");
        typeMap.put("datetime", "Date");
        typeMap.put("timestamp", "Date");
    }
}

