/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.mysql.generator;

import cn.com.duiba.mysql.generator.entity.GeneratorConfig;
import cn.com.duiba.mysql.generator.entity.TableEntity;
import cn.com.duiba.mysql.generator.exceptions.DuibaGeneratorException;
import cn.com.duiba.mysql.generator.gencode.JavaDaoGenerator;
import cn.com.duiba.mysql.generator.gencode.JavaDaoImplGenerator;
import cn.com.duiba.mysql.generator.gencode.JavaEntityGenerator;
import cn.com.duiba.mysql.generator.gencode.JavaRemoteServiceGenerator;
import cn.com.duiba.mysql.generator.gencode.JavaRemoteServiceImplGenerator;
import cn.com.duiba.mysql.generator.gencode.JavaServiceGenerator;
import cn.com.duiba.mysql.generator.gencode.JavaServiceImplGenerator;
import cn.com.duiba.mysql.generator.gencode.SQLXmlGenerator;
import cn.com.duiba.mysql.generator.service.DuibaFreemarkerService;
import cn.com.duiba.mysql.generator.utils.DBUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;

public class MybatisGenerator {
    public static void genCode(GeneratorConfig config) {
        MybatisGenerator.check(config);
        DuibaFreemarkerService freemarkerService = new DuibaFreemarkerService();
        TableEntity tableEntity = null;
        try {
            tableEntity = DBUtils.getTableInfo(config);
        }
        catch (SQLException e) {
            throw new DuibaGeneratorException(e);
        }
        if (StringUtils.isNotBlank((String)config.getRemoteServicePackage())) {
            JavaRemoteServiceGenerator remoteServiceGenerator = new JavaRemoteServiceGenerator(freemarkerService, tableEntity, config);
            remoteServiceGenerator.gen();
        }
        if (StringUtils.isNotBlank((String)config.getRemoteServiceImplPackage())) {
            JavaRemoteServiceImplGenerator remoteServiceImplGenerator = new JavaRemoteServiceImplGenerator(freemarkerService, tableEntity, config);
            remoteServiceImplGenerator.gen();
            JavaServiceGenerator serviceGenerator = new JavaServiceGenerator(freemarkerService, tableEntity, config);
            serviceGenerator.gen();
            JavaServiceImplGenerator serviceImplGenerator = new JavaServiceImplGenerator(freemarkerService, tableEntity, config);
            serviceImplGenerator.gen();
        }
        if (StringUtils.isNotBlank((String)config.getEntityPackage())) {
            JavaEntityGenerator doGenerator = new JavaEntityGenerator(freemarkerService, tableEntity, config);
            doGenerator.gen();
            JavaDaoGenerator daoGenerator = new JavaDaoGenerator(freemarkerService, tableEntity, config);
            daoGenerator.gen();
            JavaDaoImplGenerator daoImplGenerator = new JavaDaoImplGenerator(freemarkerService, tableEntity, config);
            daoImplGenerator.gen();
            SQLXmlGenerator sqlXmlGenerator = new SQLXmlGenerator(freemarkerService, tableEntity, config);
            sqlXmlGenerator.gen();
        }
    }

    private static void check(GeneratorConfig config) {
        if (config == null) {
            throw new DuibaGeneratorException("\u9422\u71b8\u579a\u6d60\uff47\u721c\u9353\u5d88\ue1ec\u7481\u5267\u7586");
        }
        config.check();
    }

    public static Connection getConnection(String url, String user, String pwd) {
        Connection connection = null;
        try {
            Class.forName("com.mysql.jdbc.Driver");
            connection = DriverManager.getConnection(url, user, pwd);
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new DuibaGeneratorException(e);
        }
        return connection;
    }
}

