/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.mysql.generator.gencode;

import cn.com.duiba.mysql.generator.entity.GeneratorConfig;
import cn.com.duiba.mysql.generator.entity.TableEntity;
import cn.com.duiba.mysql.generator.exceptions.DuibaGeneratorException;
import cn.com.duiba.mysql.generator.service.DuibaFreemarkerService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public abstract class AbstractGenerator {
    private DuibaFreemarkerService freemarkerService;
    protected TableEntity tableEntity;
    protected GeneratorConfig config;
    private Map<String, Object> params = new HashMap<String, Object>();
    private static DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm");

    public AbstractGenerator(DuibaFreemarkerService freemarkerService, TableEntity tableEntity, GeneratorConfig config) {
        this.freemarkerService = freemarkerService;
        this.tableEntity = tableEntity;
        this.config = config;
        this.params.put("nowStr", LocalDateTime.now().format(dateTimeFormatter));
        this.params.put("table", tableEntity);
        this.params.put("pk", tableEntity.getPk());
        this.params.put("pathName", tableEntity.getClassname().toLowerCase());
        this.params.put("columns", tableEntity.getColumns());
        this.params.put("entityPackage", config.getEntityPackage());
        this.params.put("remoteServicePackage", config.getRemoteServicePackage());
        this.params.put("remoteServiceImplPackage", config.getRemoteServiceImplPackage());
        this.params.put("servicePackage", config.getServicePackage());
        this.params.put("daoPackage", config.getDaoPackage());
        this.params.put("uks", tableEntity.getUniqueKeyMap());
        this.params.put("pre", "#{");
        this.params.put("end", "}");
    }

    public final void gen() {
        String genStr = this.freemarkerService.merge(this.getFTL(), this.params);
        String fileName = this.genFileName();
        String filePath = this.genFilePath();
        this.writeFile(genStr, filePath, fileName);
    }

    private void writeFile(String content, String dirPath, String fileName) {
        boolean dirs;
        File fp = new File(dirPath);
        if (!fp.exists() && !(dirs = fp.mkdirs())) {
            throw new DuibaGeneratorException(dirPath + " \u93c2\u56e6\u6b22\u9429\ue1bc\u7d8d\u9352\u6d98\u7f13\u6fb6\u8fab\u89e6");
        }
        String file = dirPath + File.separator + fileName;
        File ff = new File(file);
        if (!ff.exists()) {
            try {
                boolean success = ff.createNewFile();
                if (!success) {
                    throw new DuibaGeneratorException(file + "\u9352\u6d98\u7f13\u6fb6\u8fab\u89e6");
                }
                FileOutputStream fos = new FileOutputStream(file);
                IOUtils.write((String)content, (OutputStream)fos);
                fos.close();
            }
            catch (IOException e) {
                throw new DuibaGeneratorException(file + " error " + e);
            }
        }
    }

    protected abstract String getFTL();

    protected abstract String genFileName();

    protected abstract String genFilePath();
}

