/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.mysql.generator.service;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;

public class DuibaFreemarkerService {
    private String location;
    private String suffix;
    private Configuration cfg = new Configuration();
    private String encoding = "utf-8";

    public DuibaFreemarkerService() {
        this.cfg.setDefaultEncoding(this.encoding);
        this.cfg.setClassForTemplateLoading(DuibaFreemarkerService.class, "/tpls");
        this.cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        this.cfg.setNumberFormat("#");
        this.location = "";
        this.suffix = "ftl";
    }

    public String merge(String template, Map<String, Object> model) {
        try {
            Template tpl = this.cfg.getTemplate(template + "." + this.suffix);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(bos);
            tpl.process(model, (Writer)writer);
            writer.flush();
            writer.close();
            byte[] byteArray = bos.toByteArray();
            return new String(byteArray, this.encoding);
        }
        catch (TemplateException | IOException e) {
            throw new RuntimeException(e);
        }
    }
}

