<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE mapper PUBLIC "-//mybatis.org//DTD Mapper 3.0//EN" "http://mybatis.org/dtd/mybatis-3-mapper.dtd">

<mapper namespace="${daoPackage}.impl.${table.className}DaoImpl">
    <resultMap type="${entityPackage}.${table.className}Entity" id="propertyMap">
    <#list columns as column>
        <result property="${column.attrname}" column="${column.columnName}"/>
    </#list>
    </resultMap>

    <sql id="columns">
        <#assign idx=1><#list columns as c>
        ${c.columnName}<#if (idx<columns?size)>,</#if>
        <#assign idx=idx+1></#list>
    </sql>

    <insert id="save" <#if pk.extra == 'auto_increment'>useGeneratedKeys="true" keyProperty="${pk.attrname}"</#if>
            parameterType="${entityPackage}.${table.className}Entity">
        insert into ${table.tableName} (<#assign idx=1><#list table.mainColumns as c>${c.columnName}<#if (idx<table.mainColumns?size)>,
    </#if><#assign idx=idx+1></#list>) values (<#assign idx=1><#list table.mainColumns as c>${pre}${c.attrname}${end}<#if (idx<table.mainColumns?size)>,
    </#if><#assign idx=idx+1></#list>)
    </insert>

    <delete id="deleteBy${pk.attrName}">
        delete from ${table.tableName} where ${pk.columnName} = ${pre}${pk.attrname}${end}
    </delete>

    <delete id="deleteBatchBy${pk.attrName}s">
        delete from ${table.tableName} where ${pk.columnName} in
        <foreach item="item" index="index" collection="${pk.attrname}s" open="(" separator="," close=")">
            ${pre}item${end}
        </foreach>
    </delete>

    <update id="updateBy${pk.attrName}" parameterType="${entityPackage}.${table.className}Entity">
        update ${table.tableName}
        <set>
        <#list columns as c>
            <#if c.extra != 'auto_increment' && c.extra != "on update CURRENT_TIMESTAMP" && c.columnName != "gmt_create">
            <if test="${c.attrname} != null">
                ${c.columnName} = ${pre}${c.attrname}${end},
            </if>
            </#if>
        </#list>
        ${pk.columnName} = ${pk.columnName}
        </set>
        where ${pk.columnName} = ${pre}${pk.attrname}${end}
    </update>

    <select id="getBy${pk.attrName}" resultMap="propertyMap">
        select <include refid="columns"/>
        from ${table.tableName}
        where ${pk.columnName} = ${pre}${pk.attrname}${end}
    </select>

    <select id="listBy${pk.attrName}s" resultMap="propertyMap">
        select <include refid="columns"/>
        from ${table.tableName}
        where ${pk.columnName} in
        <foreach item="item" index="index" collection="${pk.attrname}s" open="(" separator="," close=")">
            ${pre}item${end}
        </foreach>
    </select>


<#list uks?keys as key>
    <select id="getBy${key}" resultMap="propertyMap">
        select <include refid="columns"/>
        from ${table.tableName}
        where <#assign idx=0><#list uks[key] as uk>${uk.columnName} = ${pre}${uk.attrname}${end}<#assign idx=idx+1><#if (idx<uks[key]?size)> and </#if></#list>
    </select>

    <select id="listBy${key}s" resultMap="propertyMap">
        select <include refid="columns"/>
        from ${table.tableName}
        where
        <#assign idx=0><#list uks[key] as uk>
        ${uk.columnName} in
        <foreach item="item" index="index" collection="${uk.attrname}s" open="(" separator="," close=")">
            ${pre}item${end}
        </foreach>
        <#assign idx=idx+1>
        <#if (idx<uks[key]?size)> and </#if>
    </#list>
    </select>
</#list>

</mapper>