package cn.com.duiba.nezha.engine.api.enums;

/**
 * 算法用的一个全局算法配置数据，根据这个获取缓存key
 */
public enum  CPCParamsKeyEnum {

    //用于CPC自动竞价
    CPC_AUTO_BIDING("cpcautobidding_params"),

    //用于CPC低质量标签
    CPC_NEG_TAG("cpcnegtag_params"),

    // 用于ocpc维稳控制参数
    OCPC_BID_CONTROL("nz_alg_s_m_strategy_stat_model_v001"),

    OCPC_BID_CONTROL_2("nz_alg_s_m_strategy_stat_model_v002"),

    // 广告优选融合阈值
    MERGE_THRESHOLD("nz_merge_threshold"),

    EXPLORE_PARAMS("explore_params"),

    CVRTYPE_PARAMS("cvrType_params"),

    EXPLORE_APPLIST("explore_applist"),

    RECALL_PARAMS("recall_params"),

    // 算法媒体-广告集合
    EXPLORE_ALG_APP_AD_EXPA_1("explore_alg_app_ad_expA_1"),
    EXPLORE_ALG_APP_AD_EXPA_2("explore_alg_app_ad_expA_2"),
    EXPLORE_ALG_APP_AD_EXPB_1("explore_alg_app_ad_expB_1"),
    EXPLORE_ALG_APP_AD_EXPB_2("explore_alg_app_ad_expB_2"),
    EXPLORE_ALG_APP_AD_EXPC_1("explore_alg_app_ad_expC_1"),
    EXPLORE_ALG_APP_AD_EXPC_2("explore_alg_app_ad_expC_2"),

    // 冷启动
    COLD_EXPOSE("cold_expose"),

    // 新扶持
    NEW_SUPPORT("new_support"),

    ;
    private String keyType;

    CPCParamsKeyEnum(String keyType) {
        this.keyType = keyType;
    }


    public String getKeyType() {
        return keyType;
    }
}
