package cn.com.duiba.nezha.engine.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 券次序定制广告维度枚举
 *
 * @author zhangbaiqiang
 * @date 2021/6/10
 */
@Getter
@AllArgsConstructor
public enum OrderCustomDimEnum {

    NEW_TRADE(1, "行业(新行业)"),
    RESOURCE_NAME(2, "资源名称"),
    ADVERTISER(3, "广告主id"),
    ADVERT(4, "广告计划id");

    private Integer type;
    private String desc;

    public static OrderCustomDimEnum getByType(Integer type) {
        for (OrderCustomDimEnum enumVal : OrderCustomDimEnum.values()) {
            if (Objects.equals(type, enumVal.getType())) {
                return enumVal;
            }
        }
        return null;
    }
}
