package cn.com.duiba.nezha.engine.api.constant;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.Map;

/**
 * 特征枚举
 * @author lijicong
 * @since 2021-11-05
 */
@Getter
@AllArgsConstructor
public enum AlgFeatureMapEnum {
    extAppTrade("extAppTrade", "联盟媒体行业id"),
    externalAdBlockId("externalAdBlockId", "联盟流量广告位ID"),
    externalAdBlockTypeId("externalAdBlockTypeId", "外部广告位类型ID 区分 开屏 信息流等"),
    groupId("groupId", "推广组ID"),
    resourceId("resourceId", "资源位ID"),
    ;
    private final String code;
    private final String desc;

    /**
     * 将logMap中的特征放到featureMap里
     * @param algFeatureMap
     * @param logMap
     * @return
     */
    public String putFeature(Map<String, String> algFeatureMap, Map<String, String> logMap) {
        return algFeatureMap.put(code, logMap.get(code));
    }

    /**
     * 先取logExtExpMap，如果没有再取logExtMap中的特征放到featureMap里
     * @param algFeatureMap
     * @param logExtExpMap
     * @param logExtMap
     * @return
     */
    public String putFeature(Map<String, String> algFeatureMap, Map<String, String> logExtExpMap, Map<String, String> logExtMap) {
        return algFeatureMap.put(code, logExtExpMap.getOrDefault(code, logExtMap.get(code)));
    }

    /**
     * 从featureMap中获取特征
     * @param algFeatureMap
     * @return
     */
    public String getFeature(Map<String, String> algFeatureMap) {
        return algFeatureMap != null ? algFeatureMap.get(code) : null;
    }

    /**
     * 从featureMap中获取特征
     * @param algFeatureMap
     * @return
     */
    public Long getLongFeature(Map<String, String> algFeatureMap) {
        String feature = getFeature(algFeatureMap);
        return StringUtils.isNumeric(feature) ? Long.parseLong(feature) : null;
    }
}
