package cn.com.duiba.nezha.engine.api.dto;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 用户信息
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: ConsumerDto.java , v 0.1 2017/6/8 下午6:54 ZhouFeng Exp $
 */
@Getter
@Setter
public class ConsumerDto implements Serializable {
    private static final long serialVersionUID = -3671574726638721514L;

    /**
     * 用户id
     */
    private Long consumerId;

    /**
     * 会员id
     */
    private Long memberId;

    /**
     * 地址
     */
    private String shipArea;

    /**
     * 最后登陆时间
     */
    private Date userLastlogbigintime;

    /**
     * 注册时间
     */
    private Date userRegtime;

    /**
     * 手机号
     */
    private String mobileprivate;

    /**
     * 设备id
     */
    private String deviceId;
    /**
     * deviceId类型 1-真实 2-虚拟
     */
    private Integer deviceIdType;

    /**
     * 用户安装app列表
     */
    private List<String> installApps;

    /**
     * 标签统计数
     */
    private List<TagStat> tagStats;

    /**
     * 点击感兴趣标签列表,用逗号分隔
     */
    private String clickIntersredTags;

    /**
     * 转化感兴趣标签列表,用逗号分隔
     */
    private String converIntersredTags;

    /**
     * 点击不感兴趣标签列表,用逗号分隔
     */
    private String clickUnintersredTags;

    /**
     * 转化不感兴趣标签列表,用逗号分隔
     */
    private String converUnintersredTags;

    /**
     * 性别
     */
    private String sex;
    /**
     * 年龄
     */
    private String age;

    /**
     * 工作状态
     */
    private String workStatus;

    /**
     * 学历状态
     */
    private String studentStatus;

    /**
     * 婚姻状态
     */
    private String marriageStatus;

    /**
     * 生育状态
     */
    private String bear;

    /**
     * 兴趣列表
     */
    private List<String> intersetList;

    /**
     * 设备imei号
     */
    private String imei;

    // 用户基础标签
    private List<String> userTagList;
    // 短信签名列表
    private List<String> msgList;

    // dmp各类人群标签数据
    private String dmpFeatureJsonStr;

    /**
     * md5: imei->oaid->idfa;
     * 一次有什么用什么，md5加密过后的值
     */
    private String imeiOaidIdfaMd5;

    /**
     * oneId:作为用户在推啊的唯一标识，同时也作为推啊内部匹配用户身份Id的唯一键值
     */
    private String oneId;

    /**
     * openId
     */
    private String openId;

    /**
     *oneIdType  设备号类型 1:真实设备号，2：虚拟设备号
     */
    private String oneIdType;


    /**
     * OneId用户行为特征数据
     */
    private OneIdDataDto oneIdDataDto;



}
