package cn.com.duiba.nezha.engine.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author lijicong
 * @since 2021-08-31
 */
public abstract class AppEnums {

    // 测试媒体类型
    @Getter
    @AllArgsConstructor
    public enum TestTypeEnum {
        OLD(0, "老媒体"),
        NEW_SEND_TESTED(1, "新媒体，发新媒体测试的券"),
        NEW_SEND_OTHER(2, "新媒体，未发新媒体测试券（没有回流广告、回流广告都被熔断、哪吒推荐了其他的券）"),
        NEW_TESTING(99, "标记为测试中，改为人工定向"),
        ;
        private final Integer code;
        private final String desc;

        public static Map<Integer, TestTypeEnum> map = Arrays.stream(TestTypeEnum.values())
                .collect(Collectors.toMap(TestTypeEnum::getCode, e -> e));

        public static TestTypeEnum of(Integer code) {
            return map.getOrDefault(code, TestTypeEnum.OLD);
        }

        public boolean is(Integer code) {
            return this.code.equals(code);
        }
    }
}
