/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.bo.advert.impl;

import cn.com.duiba.nezha.alg.alg.cpcautobidding.CpcAutoBidding;
import cn.com.duiba.nezha.alg.alg.cpcautobidding.CpcAutoBiddingInfo;
import cn.com.duiba.nezha.alg.alg.cpcautobidding.CpcAutoBiddingParams;
import cn.com.duiba.nezha.alg.alg.cpcautobidding.CpcAutoBiddingResult;
import cn.com.duiba.nezha.engine.biz.bo.advert.AdvertCPCAutoService;
import cn.com.duiba.nezha.engine.biz.domain.advert.OrientationPackage;
import cn.com.duiba.nezha.engine.biz.enums.AdvertStatisticsReportSubtypeEnum;
import cn.com.duiba.nezha.engine.biz.service.CacheService;
import cn.com.duiba.nezha.engine.biz.service.advert.feature.AdvertConversionDataService;
import cn.com.duiba.nezha.engine.biz.vo.advert.CpcAutoBiddingDataVo;
import cn.com.duiba.nezha.engine.common.utils.MapUtils;
import cn.com.duiba.nezha.engine.common.utils.RedisKeyUtil;
import cn.com.duiba.nezha.engine.common.utils.StringRedisHelper;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

@Service
public class AdvertCPCAutoServiceImpl
extends CacheService
implements AdvertCPCAutoService {
    @Autowired
    private AdvertConversionDataService advertConversionDataService;
    private static final String ORIENT_COST = "charge_fees";
    private static final String ORIENT_CONVERT = "cnt";
    private LoadingCache<String, CpcAutoBiddingDataVo> CpcAutoBiddingCache = CacheBuilder.newBuilder().expireAfterWrite(2L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, CpcAutoBiddingDataVo>(){

        public CpcAutoBiddingDataVo load(String key) throws Exception {
            throw new UnsupportedOperationException("not support single query");
        }

        public Map<String, CpcAutoBiddingDataVo> loadAll(Iterable<? extends String> keys) {
            return StringRedisHelper.of((StringRedisTemplate)AdvertCPCAutoServiceImpl.this.nezhaStringRedisTemplate).valueMultiGet(keys, CpcAutoBiddingDataVo.class, CpcAutoBiddingDataVo::new);
        }
    });
    private LoadingCache<String, Optional<Double>> LastCpcAutoBiddingFactorCache = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Optional<Double>>(){

        public Optional<Double> load(String key) throws Exception {
            return Optional.empty();
        }
    });
    private LoadingCache<String, CpcAutoBiddingParams> CpcAutoParamsCache = CacheBuilder.newBuilder().expireAfterWrite(2L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, CpcAutoBiddingParams>(){

        public CpcAutoBiddingParams load(String key) throws Exception {
            String params = (String)AdvertCPCAutoServiceImpl.this.nezhaStringRedisTemplate.opsForValue().get((Object)key);
            if (StringUtils.isBlank((String)params)) {
                return new CpcAutoBiddingParams();
            }
            JSONObject jsonObject = JSONObject.parseObject((String)params);
            return (CpcAutoBiddingParams)JSONObject.toJavaObject((JSON)jsonObject, CpcAutoBiddingParams.class);
        }
    });
    private LoadingCache<String, Map<String, Long>> PayAndFinishTrans7DayDataCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).build((CacheLoader)new CacheLoader<String, Map<String, Long>>(){

        public Map<String, Long> load(String key) throws Exception {
            throw new UnsupportedOperationException("not support single query");
        }

        public Map<String, Map<String, Long>> loadAll(Iterable<? extends String> keys) {
            return AdvertCPCAutoServiceImpl.this.advertConversionDataService.getAdvertConverionDataByKey(Lists.newArrayList(keys));
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OrientationPackage> getAutoBidding(List<OrientationPackage> newCPCList, Long appId) {
        try {
            DBTimeProfile.enter((String)"getAutoBidding");
            ArrayList allKeys = Lists.newArrayList();
            newCPCList.forEach(data -> {
                AutoQuery advertQuery = this.createAdvertQuery((OrientationPackage)data);
                AutoQuery advertAppQuery = this.createAdvertAppQuery((OrientationPackage)data, appId);
                allKeys.add(advertQuery);
                allKeys.add(advertAppQuery);
            });
            Map<String, CpcAutoBiddingInfo> dataFromCacheMap = this.getDataFromCache(allKeys, newCPCList, appId);
            if (dataFromCacheMap.isEmpty()) {
                List<OrientationPackage> list = newCPCList;
                return list;
            }
            CpcAutoBiddingParams cpcAutoBiddingParams = (CpcAutoBiddingParams)this.CpcAutoParamsCache.get((Object)RedisKeyUtil.getCpcAutoBiddingParamsKey());
            for (OrientationPackage data2 : newCPCList) {
                String key = data2.getAdvertId() + "_" + data2.getId() + "_" + appId;
                CpcAutoBiddingInfo cbInfo = dataFromCacheMap.get(key);
                Double lastCpcAutoBiddingFactor = ((Optional)this.LastCpcAutoBiddingFactorCache.get((Object)key)).orElse(null);
                CpcAutoBiddingResult autoBiddingResult = CpcAutoBidding.cpcAutoBiddingFactor((CpcAutoBiddingInfo)cbInfo, (Double)lastCpcAutoBiddingFactor, (CpcAutoBiddingParams)cpcAutoBiddingParams);
                Double cpcAutoBiddingFactor = Optional.ofNullable(autoBiddingResult.getCpcAutoBiddingFactor()).orElse(1.0);
                Double finalRankScore = data2.getRankScore() * cpcAutoBiddingFactor;
                Double finalFee = (double)data2.getFinalFee().longValue() * cpcAutoBiddingFactor;
                data2.setRankScore(finalRankScore);
                data2.setCpcAutoBiddingResult(autoBiddingResult);
                data2.setFinalFee(finalFee.longValue());
                this.LastCpcAutoBiddingFactorCache.put((Object)key, Optional.of(cpcAutoBiddingFactor));
            }
            List<OrientationPackage> list = newCPCList;
            return list;
        }
        catch (Exception e) {
            this.logger.error("getAutoBidding happened error:{}", (Throwable)e);
            List<OrientationPackage> list = newCPCList;
            return list;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private Map<String, CpcAutoBiddingInfo> getDataFromCache(List<AutoQuery> allKeys, List<OrientationPackage> newCPCList, Long appId2) {
        try {
            String dayFormat = LocalDate.now().format(DAY_FORMATTER);
            HashMap dayDataKeyMap = new HashMap();
            String timeFormat = LocalDateTime.now().format(HOUR_FORMATTER);
            HashMap timeDataKeyMap = new HashMap();
            allKeys.forEach(data -> {
                Long advertId = data.getAdvertId();
                Long pckgId = data.getPackageId();
                Long appId = data.getAppId();
                String key1 = RedisKeyUtil.getCPCAutoKey((Long)advertId, (Long)pckgId, (Long)appId, (String)dayFormat);
                String key2 = RedisKeyUtil.getCPCAutoKey((Long)advertId, (Long)pckgId, (Long)appId, (String)timeFormat);
                dayDataKeyMap.put(data, key1);
                timeDataKeyMap.put(data, key2);
            });
            ImmutableMap cpcAutoDayDataMap = this.CpcAutoBiddingCache.getAll(dayDataKeyMap.values());
            ImmutableMap cpcAutoTimeDataMap = this.CpcAutoBiddingCache.getAll(timeDataKeyMap.values());
            Map<String, Map<String, Long>> payOrFinishTrans7dayData = this.getPayOrFinishTrans7dayData(newCPCList, appId2, dayFormat);
            Map dayDataMap = MapUtils.translate(dayDataKeyMap, (Map)cpcAutoDayDataMap);
            Map timeDataMap = MapUtils.translate(timeDataKeyMap, (Map)cpcAutoTimeDataMap);
            return this.buildData(newCPCList, appId2, dayDataMap, timeDataMap, payOrFinishTrans7dayData, dayFormat);
        }
        catch (Exception e) {
            this.logger.error("getAutoBidding happened error:{}", (Throwable)e);
            return Maps.newHashMap();
        }
    }

    private Map<String, Map<String, Long>> getPayOrFinishTrans7dayData(List<OrientationPackage> newCPCList, Long appId2, String dayFormat) {
        List payOrFinishList = newCPCList.stream().filter(pkg -> AdvertStatisticsReportSubtypeEnum.PAY.getCode().equals(pkg.getCvrType()) || AdvertStatisticsReportSubtypeEnum.COMPLETE.getCode().equals(pkg.getCvrType())).collect(Collectors.toList());
        ArrayList rowKeys = Lists.newArrayList();
        payOrFinishList.stream().forEach(pkg -> {
            String appRowKey = this.buildPayOrFinishTrans7dayDataRowKey((OrientationPackage)pkg, appId2, dayFormat);
            String rowKey = this.buildPayOrFinishTrans7dayDataRowKey((OrientationPackage)pkg, null, dayFormat);
            rowKeys.add(rowKey);
            rowKeys.add(appRowKey);
        });
        try {
            return this.PayAndFinishTrans7DayDataCache.getAll((Iterable)rowKeys);
        }
        catch (Exception e) {
            this.logger.error("getPayOrFinishTrans7dayData happened error:{}", (Throwable)e);
            return Maps.newHashMap();
        }
    }

    private String buildPayOrFinishTrans7dayDataRowKey(OrientationPackage pkg, Long appId2, String dayFormat) {
        String str = appId2 == null ? pkg.getAdvertId() + "_" + pkg.getId() + "_" + pkg.getCvrType() + "_" + dayFormat : pkg.getAdvertId() + "_" + pkg.getId() + "_" + appId2 + "_" + pkg.getCvrType() + "_" + dayFormat;
        return DigestUtils.md5DigestAsHex((byte[])str.getBytes()).substring(0, 4) + "-" + str;
    }

    private Map<String, CpcAutoBiddingInfo> buildData(List<OrientationPackage> newCPCList, Long appId, Map<AutoQuery, CpcAutoBiddingDataVo> dayDataMap, Map<AutoQuery, CpcAutoBiddingDataVo> timeDataMap, Map<String, Map<String, Long>> payOrFinishTrans7dayData, String dayformate) {
        HashMap<String, CpcAutoBiddingInfo> resultMap = new HashMap<String, CpcAutoBiddingInfo>();
        newCPCList.forEach(data -> {
            Long advertId = data.getAdvertId();
            Long orientId = data.getId();
            String cvrType = data.getCvrType().toString();
            String key = advertId + "_" + orientId + "_" + appId;
            String advertAppCvrtypeKey = this.buildPayOrFinishTrans7dayDataRowKey((OrientationPackage)data, appId, dayformate);
            String advertCvrtypeKey = this.buildPayOrFinishTrans7dayDataRowKey((OrientationPackage)data, null, dayformate);
            CpcAutoBiddingInfo cbInfo = new CpcAutoBiddingInfo();
            cbInfo.setAdvertId(advertId);
            cbInfo.setOrientId(orientId);
            cbInfo.setAppId(appId);
            cbInfo.setConvertType(data.getCvrType());
            cbInfo.setAutoBiddingType(data.getAutoBiddingType());
            cbInfo.setTarget(data.getConvertCost());
            AutoQuery advertQuery = this.createAdvertQuery((OrientationPackage)data);
            AutoQuery advertAppQuery = this.createAdvertAppQuery((OrientationPackage)data, appId);
            CpcAutoBiddingDataVo dayAdvertAppVo = dayDataMap.getOrDefault(advertAppQuery, new CpcAutoBiddingDataVo());
            Map<String, Long> dayBackendCntAdvertAppMap = dayAdvertAppVo.getBackendCntMap();
            CpcAutoBiddingDataVo timeAdvertAppVo = timeDataMap.getOrDefault(advertAppQuery, new CpcAutoBiddingDataVo());
            Map<String, Long> timeBackendCntAdvertAppMap = timeAdvertAppVo.getBackendCntMap();
            cbInfo.setOrientAppCostToday(dayAdvertAppVo.getChargeFees());
            cbInfo.setOrientAppConvertToday(AdvertStatisticsReportSubtypeEnum.LAND.getCode().equals(cvrType) ? dayAdvertAppVo.getActClickCnt() : dayBackendCntAdvertAppMap.getOrDefault(cvrType, 0L));
            cbInfo.setOrientAppBiddingCntToday(dayAdvertAppVo.getBidCnt());
            cbInfo.setOrientAppRankScore10(dayAdvertAppVo.getScore10());
            cbInfo.setOrientAppRankScore9(dayAdvertAppVo.getScore9());
            cbInfo.setOrientAppRankScore8(dayAdvertAppVo.getScore8());
            Map payOrFinishAppDataMap = (Map)payOrFinishTrans7dayData.get(advertAppCvrtypeKey);
            if (payOrFinishAppDataMap != null) {
                cbInfo.setOrientAppConvert7day(payOrFinishAppDataMap.getOrDefault(ORIENT_CONVERT, 0L));
                cbInfo.setOrientAppCost7day(payOrFinishAppDataMap.getOrDefault(ORIENT_COST, 0L));
            }
            cbInfo.setOrientAppCostHour(timeAdvertAppVo.getChargeFees());
            cbInfo.setOrientAppConvertHour(AdvertStatisticsReportSubtypeEnum.LAND.getCode().equals(cvrType) ? timeAdvertAppVo.getActClickCnt() : timeBackendCntAdvertAppMap.getOrDefault(cvrType, 0L));
            cbInfo.setOrientAppBiddingCntHour(timeAdvertAppVo.getBidCnt());
            cbInfo.setOrientAppHourRankScore10(timeAdvertAppVo.getScore10());
            cbInfo.setOrientAppHourRankScore9(timeAdvertAppVo.getScore9());
            cbInfo.setOrientAppHourRankScore8(timeAdvertAppVo.getScore8());
            CpcAutoBiddingDataVo dayAdvertVo = dayDataMap.getOrDefault(advertQuery, new CpcAutoBiddingDataVo());
            Map<String, Long> dayBackendCntAdvertMap = dayAdvertVo.getBackendCntMap();
            CpcAutoBiddingDataVo timeAdvertVo = timeDataMap.getOrDefault(advertQuery, new CpcAutoBiddingDataVo());
            Map<String, Long> timeBackendCntAdvertMap = timeAdvertVo.getBackendCntMap();
            cbInfo.setOrientCostToday(dayAdvertVo.getChargeFees());
            cbInfo.setOrientConvertToday(AdvertStatisticsReportSubtypeEnum.LAND.getCode().equals(cvrType) ? dayAdvertVo.getActClickCnt() : dayBackendCntAdvertMap.getOrDefault(cvrType, 0L));
            cbInfo.setOrientBiddingCntToday(dayAdvertVo.getBidCnt());
            cbInfo.setOrientRankScore10(dayAdvertVo.getScore10());
            cbInfo.setOrientRankScore9(dayAdvertVo.getScore9());
            cbInfo.setOrientRankScore8(dayAdvertVo.getScore8());
            Map payOrFinishDataMap = (Map)payOrFinishTrans7dayData.get(advertCvrtypeKey);
            if (payOrFinishDataMap != null) {
                cbInfo.setOrientConvert7day(payOrFinishDataMap.getOrDefault(ORIENT_CONVERT, 0L));
                cbInfo.setOrientCost7day(payOrFinishDataMap.getOrDefault(ORIENT_COST, 0L));
            }
            cbInfo.setOrientCostHour(timeAdvertVo.getChargeFees());
            cbInfo.setOrientConvertHour(AdvertStatisticsReportSubtypeEnum.LAND.getCode().equals(cvrType) ? timeAdvertVo.getActClickCnt() : timeBackendCntAdvertMap.getOrDefault(cvrType, 0L));
            cbInfo.setOrientBiddingCntHour(timeAdvertVo.getBidCnt());
            cbInfo.setOrientHourRankScore10(timeAdvertVo.getScore10());
            cbInfo.setOrientHourRankScore9(timeAdvertVo.getScore9());
            cbInfo.setOrientHourRankScore8(timeAdvertVo.getScore8());
            resultMap.put(key, cbInfo);
        });
        return resultMap;
    }

    private AutoQuery createAdvertQuery(OrientationPackage data) {
        AutoQuery advertQuery = new AutoQuery();
        advertQuery.setAdvertId(data.getAdvertId());
        advertQuery.setPackageId(data.getId());
        return advertQuery;
    }

    private AutoQuery createAdvertAppQuery(OrientationPackage data, Long appId) {
        AutoQuery advertAppQuery = new AutoQuery();
        advertAppQuery.setAdvertId(data.getAdvertId());
        advertAppQuery.setPackageId(data.getId());
        advertAppQuery.setAppId(appId);
        return advertAppQuery;
    }

    class AutoQuery {
        private Long advertId;
        private Long packageId;
        private Long appId;

        AutoQuery() {
        }

        public Long getAdvertId() {
            return this.advertId;
        }

        public void setAdvertId(Long advertId) {
            this.advertId = advertId;
        }

        public Long getPackageId() {
            return this.packageId;
        }

        public void setPackageId(Long packageId) {
            this.packageId = packageId;
        }

        public Long getAppId() {
            return this.appId;
        }

        public void setAppId(Long appId) {
            this.appId = appId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AutoQuery)) {
                return false;
            }
            AutoQuery that = (AutoQuery)o;
            return Objects.equals(this.advertId, that.advertId) && Objects.equals(this.packageId, that.packageId) && Objects.equals(this.appId, that.appId);
        }

        public int hashCode() {
            return Objects.hash(this.advertId, this.packageId, this.appId);
        }
    }
}

