/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.domain;

import com.alibaba.fastjson.annotation.JSONField;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class StatisticData {
    @JSONField(name="launchCnt")
    private Long launchCount;
    @JSONField(name="chargeCnt")
    private Long chargeClickCount;
    @JSONField(name="actExpCnt")
    private Long exposureCount;
    @JSONField(name="actClickCnt")
    private Long convertCount;
    @JSONField(name="chargeFees")
    private Long totalConsume;
    private Double ctr;
    private Double cvr;
    private Map<String, Long> backendCntMap;
    private Map<String, Double> backendCvrMap;

    public Long getTotalConsume() {
        return Optional.ofNullable(this.totalConsume).orElse(0L);
    }

    public void setTotalConsume(Long totalConsume) {
        this.totalConsume = totalConsume;
    }

    public Long getLaunchCount() {
        return Optional.ofNullable(this.launchCount).orElse(0L);
    }

    public void setLaunchCount(Long launchCount) {
        this.launchCount = launchCount;
    }

    public Long getChargeClickCount() {
        return Optional.ofNullable(this.chargeClickCount).orElse(0L);
    }

    public void setChargeClickCount(Long chargeClickCount) {
        this.chargeClickCount = chargeClickCount;
    }

    public Long getExposureCount() {
        return Optional.ofNullable(this.exposureCount).orElse(0L);
    }

    public void setExposureCount(Long exposureCount) {
        this.exposureCount = exposureCount;
    }

    public Long getConvertCount() {
        return Optional.ofNullable(this.convertCount).orElse(0L);
    }

    public Long getConvertCount(Integer cvrType) {
        if (cvrType.equals(0)) {
            return this.getConvertCount();
        }
        return this.getBackendCntMap().getOrDefault(cvrType.toString(), 0L);
    }

    public void setConvertCount(Long convertCount) {
        this.convertCount = convertCount;
    }

    public Double getCtr() {
        return Optional.ofNullable(this.ctr).orElse(0.0);
    }

    public void setCtr(Double ctr) {
        this.ctr = ctr;
    }

    public Double getCvr() {
        return Optional.ofNullable(this.cvr).orElse(0.0);
    }

    public Double getCvr(Integer cvrType) {
        if (cvrType.equals(0)) {
            return this.getCvr();
        }
        return this.getBackendCvrMap().getOrDefault(cvrType.toString(), this.getCvr());
    }

    public void setCvr(Double cvr) {
        this.cvr = cvr;
    }

    public Map<String, Long> getBackendCntMap() {
        return Optional.ofNullable(this.backendCntMap).orElseGet(HashMap::new);
    }

    public void setBackendCntMap(Map<String, Long> backendCntMap) {
        this.backendCntMap = backendCntMap;
    }

    public Map<String, Double> getBackendCvrMap() {
        return Optional.ofNullable(this.backendCvrMap).orElseGet(HashMap::new);
    }

    public void setBackendCvrMap(Map<String, Double> backendCvrMap) {
        this.backendCvrMap = backendCvrMap;
    }
}

