/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.enums;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum BackendDefaultCVR {
    _0("0", 0.02),
    _1("1", 0.01),
    _2("2", 0.01),
    _3("3", 0.01),
    _4("4", 0.01),
    _6("6", 0.01),
    _8("8", 0.01);

    private String type;
    private Double cvr;
    private static final Map<String, BackendDefaultCVR> CACHE;

    public String getType() {
        return this.type;
    }

    public Double getCvr() {
        return this.cvr;
    }

    private BackendDefaultCVR(String type, Double cvr) {
        this.type = type;
        this.cvr = cvr;
    }

    public static Double getCvr(Integer type) {
        return CACHE.get(type.toString()).getCvr();
    }

    static {
        CACHE = Stream.of(BackendDefaultCVR.values()).collect(Collectors.toMap(BackendDefaultCVR::getType, Function.identity()));
    }
}

