/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.log;

import cn.com.duiba.nezha.engine.biz.entity.nezha.advert.BizLogEntity;
import cn.com.duiba.nezha.engine.biz.entity.nezha.advert.DegradedLogEntity;
import cn.com.duiba.nezha.engine.biz.entity.nezha.advert.RoiLogEntity;
import cn.com.duiba.nezha.engine.biz.log.BaseInnerRuleDto;
import com.alibaba.fastjson.JSON;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseInnerLog {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseInnerLog.class);
    private static final String ADVERT_INNER_LOG_GROUP = "1";
    private static final String ADVERT_INNER_LOG_RECOMMEND = "38";
    private static final String DEGRADED_GIVE_UP_LOG = "165";
    private static final String ENCOURAGE_ADVERT_INNER_LOG_RECOMMEND = "138";
    private static final String ADXPRE_ADVERT_INNER_LOG_RECOMMEND = "238";
    private static final String ADVERT_INNER_LOG_FEATURE = "48";
    private static final String ENCOURAGE_ADVERT_INNER_LOG_FEATURE = "139";
    private static final String ADXPRE_ADVERT_INNER_LOG_FEATURE = "239";
    private static final String ADVERT_ROI_LOG = "120";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public static void log(BizLogEntity bizLogEntity) {
        Optional.ofNullable(bizLogEntity).ifPresent(entry -> BaseInnerLog.log(ADVERT_INNER_LOG_RECOMMEND, JSON.toJSONString((Object)entry)));
    }

    public static void logToEncourage(BizLogEntity bizLogEntity) {
        Optional.ofNullable(bizLogEntity).ifPresent(entry -> BaseInnerLog.log(ENCOURAGE_ADVERT_INNER_LOG_RECOMMEND, JSON.toJSONString((Object)entry)));
    }

    public static void logToADXPre(BizLogEntity bizLogEntity) {
        Optional.ofNullable(bizLogEntity).ifPresent(entry -> BaseInnerLog.log(ADXPRE_ADVERT_INNER_LOG_RECOMMEND, JSON.toJSONString((Object)entry)));
    }

    public static void log(RoiLogEntity roiLogEntity) {
        Optional.ofNullable(roiLogEntity).ifPresent(entry -> BaseInnerLog.log(ADVERT_ROI_LOG, JSON.toJSONString((Object)entry)));
    }

    public static void log(Map<String, String> featureMap) {
        if (MapUtils.isNotEmpty(featureMap)) {
            BaseInnerLog.log(ADVERT_INNER_LOG_FEATURE, JSON.toJSONString(featureMap));
        }
    }

    public static void logToEncourage(Map<String, String> featureMap) {
        if (MapUtils.isNotEmpty(featureMap)) {
            BaseInnerLog.log(ENCOURAGE_ADVERT_INNER_LOG_FEATURE, JSON.toJSONString(featureMap));
        }
    }

    public static void logToADXPre(Map<String, String> featureMap) {
        if (MapUtils.isNotEmpty(featureMap)) {
            BaseInnerLog.log(ADXPRE_ADVERT_INNER_LOG_FEATURE, JSON.toJSONString(featureMap));
        }
    }

    private static void log(String logType, String jsonLog) {
        BaseInnerRuleDto ruleDto = new BaseInnerRuleDto();
        ruleDto.setGroup(ADVERT_INNER_LOG_GROUP);
        ruleDto.setJson(jsonLog);
        ruleDto.setTime(LocalDateTime.now().format(DATE_TIME_FORMATTER));
        ruleDto.setType(logType);
        LOGGER.info(JSON.toJSONString((Object)ruleDto));
    }

    private BaseInnerLog() {
    }

    public static void logToDegraded(DegradedLogEntity degradedLogEntity) {
        if (degradedLogEntity == null) {
            return;
        }
        BaseInnerLog.log(DEGRADED_GIVE_UP_LOG, JSON.toJSONString((Object)degradedLogEntity));
    }
}

