/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.message.advert.ons;

import cn.com.duiba.nezha.engine.biz.message.advert.ons.AbstractMessageResultHandler;
import cn.com.duiba.nezha.engine.biz.message.advert.ons.OnsRoiControllerMessageTag;
import cn.com.duiba.nezha.engine.biz.message.advert.ons.RocketMqMessageListener;
import cn.com.duiba.nezha.engine.biz.support.StringTool;
import cn.com.duiba.nezha.engine.common.utils.MultiStringUtils;
import cn.com.duiba.nezha.engine.common.utils.RedisKeyUtil;
import cn.com.duiba.nezha.engine.common.utils.RoiHashKeyUtil;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSONObject;
import com.dianping.cat.Cat;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.StringRedisConnection;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class RoiCvrMessageHandler
extends AbstractMessageResultHandler {
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public String getListenTag() {
        return OnsRoiControllerMessageTag.ROI_CVR.getTag();
    }

    @Override
    public void consumer(String message) {
        if (StringUtils.isNotBlank((String)message)) {
            JSONObject json = JSONObject.parseObject((String)message);
            String advertId = json.getString("adid");
            String packageId = json.getString("packageId");
            String appId = json.getString("appId");
            String slotId = json.getString("slotId");
            String activityId = json.getString("activityId");
            Integer cvrType = json.getInteger("cvrType");
            Object hitUserInterest = json.get((Object)"hitUserInterest");
            if (MultiStringUtils.isAnyBlank((String[])new String[]{advertId, packageId, appId, slotId, activityId})) {
                this.logger.warn("conusmer message:{} error,illegal argument", (Object)message);
                return;
            }
            Cat.logMetricForCount((String)"roiAction");
            String key = RedisKeyUtil.roiCvrKey((String)advertId, (String)packageId, (LocalDate)LocalDate.now());
            Set<String> allHitTags = this.getAllHitTags(hitUserInterest, appId, slotId, cvrType);
            this.stringRedisTemplate.executePipelined(connection -> {
                StringRedisConnection stringRedisConn = (StringRedisConnection)connection;
                stringRedisConn.hIncrBy(key, RoiHashKeyUtil.getDefault((Integer)cvrType), 1L);
                stringRedisConn.hIncrBy(key, RoiHashKeyUtil.getAppKey((Object)appId, (Integer)cvrType), 1L);
                stringRedisConn.hIncrBy(key, RoiHashKeyUtil.getSlotKey((Object)slotId, (Integer)cvrType), 1L);
                stringRedisConn.hIncrBy(key, RoiHashKeyUtil.getActivityKey((Object)appId, (String)activityId, (Integer)cvrType), 1L);
                if (CollectionUtils.isNotEmpty((Collection)allHitTags)) {
                    allHitTags.forEach(hitUserTag -> stringRedisConn.hIncrBy(key, hitUserTag, 1L));
                }
                stringRedisConn.expire(key, (long)DateUtils.getToTomorrowSeconds() + (long)new Random().nextInt(100));
                return null;
            });
        }
    }

    private Set<String> getAllHitTags(Object hitUserInterest, String appId, String slotId, Integer cvrType) {
        HashSet<String> allHitTags = new HashSet<String>();
        if (!ObjectUtils.isEmpty((Object)hitUserInterest)) {
            Set<String> hitUserTags = StringTool.getStringSetByStr(hitUserInterest.toString(), "_");
            hitUserTags.forEach(hitUserTag -> {
                allHitTags.add(RoiHashKeyUtil.getTagAppKey((Object)appId, (String)hitUserTag, (Integer)cvrType));
                allHitTags.add(RoiHashKeyUtil.getTagSlotKey((Object)slotId, (String)hitUserTag, (Integer)cvrType));
                allHitTags.add(RoiHashKeyUtil.getTagKey((String)hitUserTag, (Integer)cvrType));
            });
        }
        return allHitTags;
    }

    public void afterPropertiesSet() throws Exception {
        RocketMqMessageListener.registerCallback(this);
    }
}

