/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert;

import cn.com.duiba.nezha.alg.model.enums.PredictResultType;
import cn.com.duiba.nezha.engine.api.enums.PredictCorrectType;
import cn.com.duiba.nezha.engine.biz.bo.advert.AdvertAutoBiddingFactorService;
import cn.com.duiba.nezha.engine.biz.bo.advert.AdvertBudgetSmoothService;
import cn.com.duiba.nezha.engine.biz.constant.GlobalConstant;
import cn.com.duiba.nezha.engine.biz.domain.ConsumerDo;
import cn.com.duiba.nezha.engine.biz.domain.CorrectResult;
import cn.com.duiba.nezha.engine.biz.domain.FeatureIndex;
import cn.com.duiba.nezha.engine.biz.domain.advert.Advert;
import cn.com.duiba.nezha.engine.biz.domain.advert.Material;
import cn.com.duiba.nezha.engine.biz.domain.advert.OrientationPackage;
import cn.com.duiba.nezha.engine.biz.enums.RecommendMaterialType;
import cn.com.duiba.nezha.engine.biz.service.advert.ctr.AdvertPredictCorrectService;
import cn.com.duiba.nezha.engine.biz.service.advert.ctr.AdvertPredictService;
import cn.com.duiba.nezha.engine.biz.service.advert.material.AdvertMaterialService;
import cn.com.duiba.nezha.engine.biz.service.advert.merge.AdvertDataMergeService;
import cn.com.duiba.nezha.engine.biz.service.advert.rerank.AdvertReRankService;
import cn.com.duiba.nezha.engine.biz.vo.advert.AdvertRecommendRequestVo;
import cn.com.duiba.nezha.engine.common.utils.ListToMapTools;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractAdvertRecommendService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAdvertRecommendService.class);
    @Resource
    private AdvertReRankService advertReRankService;
    @Resource
    private AdvertDataMergeService advertDataMergeService;
    @Autowired
    private AdvertMaterialService advertMaterialService;
    @Autowired
    private AdvertPredictCorrectService advertPredictCorrectService;
    @Autowired
    private AdvertPredictService advertPredictService;
    @Autowired
    private AdvertBudgetSmoothService advertBudgetSmoothService;
    @Autowired
    private AdvertAutoBiddingFactorService advertAutoBiddingFactorService;

    public abstract void prepareStrategyParameter(AdvertRecommendRequestVo var1);

    public List<OrientationPackage> recommend(AdvertRecommendRequestVo advertRecommendRequestVo) throws Throwable {
        Map<Long, Advert> advertMap = advertRecommendRequestVo.getAdvertMap();
        Collection<Advert> adverts = advertMap.values();
        Long appId = advertRecommendRequestVo.getAppDo().getId();
        Integer adxLoadType = advertRecommendRequestVo.getRequestDo().getAdxLoadType();
        Map<Object, Object> predictValueMap = new HashMap();
        if (advertRecommendRequestVo.getNeedPredict().booleanValue()) {
            Set needPredictCvrAdverts = adverts.stream().filter(Advert::hasCvrData).collect(Collectors.toSet());
            HashMap<PredictResultType, Collection<Advert>> needPredictAdvertMap = new HashMap<PredictResultType, Collection<Advert>>();
            needPredictAdvertMap.put(PredictResultType.CTR, adverts);
            needPredictAdvertMap.put(PredictResultType.CVR, needPredictCvrAdverts);
            predictValueMap = this.advertPredictService.predict(advertRecommendRequestVo, needPredictAdvertMap);
            Map predictCtrMap = (Map)predictValueMap.get(PredictResultType.CTR);
            Map predictCvrMap = (Map)predictValueMap.get(PredictResultType.CVR);
            advertRecommendRequestVo.setPredictCtr(predictCtrMap);
            advertRecommendRequestVo.setPredictCvr(predictCvrMap);
        }
        CatUtils.executeInCatTransaction(() -> {
            this.advertBudgetSmoothService.getNewBudgetSmooth(appId, advertRecommendRequestVo.getAdvertOrientationPackages(), adxLoadType);
            return null;
        }, (String)"recommend", (String)"advertBudgetSmoothService#getNewBudgetSmooth");
        RecommendMaterialType recommendMaterialType = advertRecommendRequestVo.getRecommendMaterialType();
        Map predictCtrMap = predictValueMap.getOrDefault(PredictResultType.CTR, new HashMap());
        Map predictCvrMap = predictValueMap.getOrDefault(PredictResultType.CVR, new HashMap());
        CatUtils.executeInCatTransaction(() -> {
            this.handleTestMaterial(adverts, appId, recommendMaterialType, predictCtrMap, predictCvrMap);
            return null;
        }, (String)"recommend", (String)"abstractAdvertRecommendService#handleTestMaterial");
        PredictCorrectType predictCorrectType = advertRecommendRequestVo.getPredictCorrectType();
        if (!predictCorrectType.equals((Object)PredictCorrectType.NONE) && recommendMaterialType.equals((Object)RecommendMaterialType.NONE)) {
            CorrectResult correctResult = this.advertPredictCorrectService.correct(advertRecommendRequestVo, predictValueMap);
            Map<PredictResultType, Map<Long, Double>> reconstructionFactorMap = correctResult.getReconstructionFactorMap();
            Map<PredictResultType, Map<Long, Double>> correctionFactorMap = correctResult.getCorrectionFactorMap();
            Map ctrReconstructionFactorMap = reconstructionFactorMap.getOrDefault(PredictResultType.CTR, new HashMap());
            Map ctrCorrectionFactorMap = correctionFactorMap.getOrDefault(PredictResultType.CTR, new HashMap());
            Map cvrReconstructionFactorMap = reconstructionFactorMap.getOrDefault(PredictResultType.CVR, new HashMap());
            Map cvrCorrectionFactorMap = correctionFactorMap.getOrDefault(PredictResultType.CVR, new HashMap());
            advertRecommendRequestVo.setCtrReconstructionFactorMap(ctrReconstructionFactorMap);
            advertRecommendRequestVo.setCvrReconstructionFactorMap(cvrReconstructionFactorMap);
            advertRecommendRequestVo.setCtrCorrectionFactorMap(ctrCorrectionFactorMap);
            advertRecommendRequestVo.setCvrCorrectionFactorMap(cvrCorrectionFactorMap);
        }
        ConsumerDo consumerDo = advertRecommendRequestVo.getConsumerDo();
        Map<Long, Integer> userAdvertBehaviorMap = this.userAdvertBehavior(adverts, consumerDo);
        advertRecommendRequestVo.setUserAdvertBehaviorMap(userAdvertBehaviorMap);
        CatUtils.executeInCatTransaction(() -> {
            this.advertAutoBiddingFactorService.setAutoBiddingNewFee(advertRecommendRequestVo);
            return null;
        }, (String)"recommend", (String)"advertAutoBiddingFactorService#setAutoBiddingNewFee");
        List orientationPackages = (List)CatUtils.executeInCatTransaction(() -> this.advertDataMergeService.dataMerge(advertRecommendRequestVo), (String)"recommend", (String)"advertDataMergeService#dataMerge");
        return (List)CatUtils.executeInCatTransaction(() -> this.advertReRankService.newReRank(orientationPackages, appId), (String)"recommend", (String)"advertReRankService#reRank");
    }

    public void handleTestMaterial(Collection<Advert> adverts, Long appId, RecommendMaterialType recommendMaterialType, Map<FeatureIndex, Double> predictCtrMap, Map<FeatureIndex, Double> predictCvrMap) {
        if (recommendMaterialType.equals((Object)RecommendMaterialType.NONE)) {
            return;
        }
        Set<Long> advertIds = adverts.stream().map(Advert::getId).collect(Collectors.toSet());
        HashMap<Long, List<Long>> materialRankList = new HashMap<Long, List<Long>>();
        if (recommendMaterialType.equals((Object)RecommendMaterialType.STATIC)) {
            materialRankList.putAll(this.advertMaterialService.getMaterialRankList(appId, advertIds));
        }
        adverts.stream().map(Advert::getOrientationPackages).flatMap(Collection::stream).forEach(orientationPackage -> {
            Long advertId = orientationPackage.getAdvertId();
            Long packageId = orientationPackage.getId();
            if (recommendMaterialType.equals((Object)RecommendMaterialType.STATIC)) {
                orientationPackage.setMaterials(this.selectMaterial((OrientationPackage)orientationPackage, (Map<Long, List<Long>>)materialRankList));
            } else {
                Boolean cpa = orientationPackage.isCpa();
                Set bestMaterial = orientationPackage.getMaterials().stream().max(Comparator.comparing(material -> {
                    Long materialId = material.getId();
                    FeatureIndex featureIndex = new FeatureIndex(advertId, packageId, materialId);
                    Double ctrValue = predictCtrMap.getOrDefault(featureIndex, 0.0);
                    Double cvrValue = predictCvrMap.getOrDefault(featureIndex, 0.0);
                    if (cpa.booleanValue()) {
                        return ctrValue * cvrValue;
                    }
                    return ctrValue;
                })).map(Collections::singleton).orElseGet(HashSet::new);
                orientationPackage.setMaterials(bestMaterial);
            }
        });
    }

    private Set<Material> selectMaterial(OrientationPackage orientationPackage, Map<Long, List<Long>> materialRankList) {
        Set<Material> materials = orientationPackage.getMaterials();
        if (materials.isEmpty()) {
            return new HashSet<Material>();
        }
        List<Long> materialIds = materialRankList.get(orientationPackage.getAdvertId());
        Map collect = ListToMapTools.toMap(materials, Material::getId, Function.identity());
        Set requestMaterials = collect.keySet();
        Material finalMaterial = materialIds.stream().filter(requestMaterials::contains).findAny().map(collect::get).orElse(new ArrayList<Material>(materials).get(new Random().nextInt(materials.size())));
        return Collections.singleton(finalMaterial);
    }

    private Map<Long, Integer> userAdvertBehavior(Collection<Advert> adverts, ConsumerDo consumerDo) {
        HashMap<Long, Integer> advertBehaviorMap = new HashMap<Long, Integer>(adverts.size());
        String clickInterestedTags = consumerDo.getClickInterestedTags();
        String clickUninterestedTags = consumerDo.getClickUninterestedTags();
        String convertInterestedTags = consumerDo.getConvertInterestedTags();
        String convertUninterestedTags = consumerDo.getConvertUninterestedTags();
        Splitter splitter = GlobalConstant.SPLITTER;
        HashSet<String> clickInterestedTagSet = StringUtils.isEmpty((String)clickInterestedTags) ? Collections.emptySet() : new HashSet<String>(splitter.splitToList((CharSequence)clickInterestedTags));
        HashSet<String> clickUninterestedTagSet = StringUtils.isEmpty((String)clickUninterestedTags) ? Collections.emptySet() : new HashSet<String>(splitter.splitToList((CharSequence)clickUninterestedTags));
        HashSet<String> convertInterestedTagSet = StringUtils.isEmpty((String)convertInterestedTags) ? Collections.emptySet() : new HashSet<String>(splitter.splitToList((CharSequence)convertInterestedTags));
        HashSet<String> convertUninterestedTagSet = StringUtils.isEmpty((String)convertUninterestedTags) ? Collections.emptySet() : new HashSet<String>(splitter.splitToList((CharSequence)convertUninterestedTags));
        for (Advert advert : adverts) {
            String matchTags = advert.getMatchTags();
            HashSet<String> matchTagNumSet = StringUtils.isEmpty((String)matchTags) ? Collections.emptySet() : new HashSet<String>(splitter.splitToList((CharSequence)matchTags));
            int type = this.getType(clickInterestedTagSet, clickUninterestedTagSet, convertInterestedTagSet, convertUninterestedTagSet, matchTagNumSet);
            advertBehaviorMap.put(advert.getId(), type);
        }
        return advertBehaviorMap;
    }

    private int getType(Set<String> clickInterestedTagSet, Set<String> clickUninterestedTagSet, Set<String> convertInterestedTagSet, Set<String> convertUninterestedTagSet, Set<String> matchTagNumSet) {
        int type = 0;
        if (CollectionUtils.isNotEmpty((Collection)Sets.intersection(clickInterestedTagSet, matchTagNumSet))) {
            type |= 8;
        }
        if (CollectionUtils.isNotEmpty((Collection)Sets.intersection(clickUninterestedTagSet, matchTagNumSet))) {
            type |= 4;
        }
        if (CollectionUtils.isNotEmpty((Collection)Sets.intersection(convertInterestedTagSet, matchTagNumSet))) {
            type |= 2;
        }
        if (CollectionUtils.isNotEmpty((Collection)Sets.intersection(convertUninterestedTagSet, matchTagNumSet))) {
            type |= 1;
        }
        return type;
    }
}

