/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert;

import cn.com.duiba.nezha.engine.biz.domain.AppDo;
import cn.com.duiba.nezha.engine.biz.domain.advert.OrientationPackage;
import cn.com.duiba.nezha.engine.biz.service.CacheService;
import cn.com.duiba.nezha.engine.biz.support.StringTool;
import cn.com.duiba.nezha.engine.common.utils.RedisKeyUtil;
import cn.com.duiba.nezha.engine.common.utils.RoiHashKeyUtil;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service
@RefreshScope
public class OrientationPackageAdjustPriceFactorService
extends CacheService {
    private static final String TAG = "TAG";
    private static final String APP = "APP";
    private static final String SLOT = "SLOT";
    public static final String DEFAULT = "DEFAULT";
    @Value(value="${ocpxAbtestChance:0.0}")
    private Double ocpxAbtestChance;
    @Value(value="${ocpxWhiteForTag}")
    private String ocpxWhiteForTag;
    private LoadingCache<String, Double> factorCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Double>(){

        public Double load(String key) {
            throw new UnsupportedOperationException("not support single query");
        }

        public Map<String, Double> loadAll(Iterable<? extends String> keys) {
            ArrayList keyList = Lists.newArrayList(keys);
            HashMap<String, Double> factorMap = new HashMap<String, Double>(keyList.size());
            List values = OrientationPackageAdjustPriceFactorService.this.nezhaStringRedisTemplate.opsForValue().multiGet((Collection)keyList);
            for (int index = 0; index < keyList.size(); ++index) {
                String key = (String)keyList.get(index);
                String value = Optional.ofNullable(values.get(index)).orElse("1");
                factorMap.put(key, Double.valueOf(value));
            }
            return factorMap;
        }
    });

    public static final boolean isLuck(double chance) {
        int chanceInt = (int)chance * 100;
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        return ((Random)rand).nextInt(10000) <= chanceInt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Set<OrientationPackage> orientationPackages, AppDo appDo) {
        try {
            DBTimeProfile.enter((String)"loadAdjustPriceFactors");
            Long appId = appDo.getId();
            Long slotId = appDo.getSlotId();
            String appUserInterest = appDo.getAppUserInterest();
            List<String> appUserInterestList = StringTool.getStringListByStr(appUserInterest, "_");
            ArrayList keys = new ArrayList(orientationPackages.size() * 3);
            HashMap advert2dimKeysMap = new HashMap(orientationPackages.size());
            HashMap advertTagdimKeysMap = new HashMap(orientationPackages.size());
            boolean hitAbtest = OrientationPackageAdjustPriceFactorService.isLuck(this.ocpxAbtestChance);
            List<String> ocpxWhiteForTagList = StringTool.getStringListByStr(this.ocpxWhiteForTag, ";");
            orientationPackages.forEach(orientationPackage -> {
                Long advertId = orientationPackage.getAdvertId();
                Long packageId = orientationPackage.getId();
                Integer cvrType = orientationPackage.getCvrType();
                ArrayList<String> dimKeys = new ArrayList<String>();
                boolean tagWhiteByAdvertPkg = OrientationPackageAdjustPriceFactorService.isTagWhiteByAdvertPkg(ocpxWhiteForTagList, advertId, packageId);
                if (CollectionUtils.isNotEmpty((Collection)appUserInterestList) && hitAbtest && tagWhiteByAdvertPkg) {
                    orientationPackage.setOcpxAbTest(hitAbtest);
                    List<String> allHitTagKeys = this.getAllHitTagKeys((OrientationPackage)orientationPackage, appUserInterestList, appId, slotId);
                    advertTagdimKeysMap.put(orientationPackage, allHitTagKeys);
                    dimKeys.addAll(allHitTagKeys);
                }
                String slotKey = RedisKeyUtil.factorKey((Long)advertId, (Long)packageId, (String)RoiHashKeyUtil.getSlotKey((Object)slotId, (Integer)cvrType));
                String appKey = RedisKeyUtil.factorKey((Long)advertId, (Long)packageId, (String)RoiHashKeyUtil.getAppKey((Object)appId, (Integer)cvrType));
                String defaultKey = RedisKeyUtil.factorKey((Long)advertId, (Long)packageId, (String)RoiHashKeyUtil.getDefault((Integer)cvrType));
                dimKeys.add(defaultKey);
                keys.addAll(dimKeys);
                advert2dimKeysMap.put(orientationPackage, dimKeys);
            });
            ImmutableMap factorMap = new HashMap(0);
            try {
                factorMap = this.factorCache.getAll(keys);
            }
            catch (Exception e) {
                this.logger.error("load factor error :{}", (Throwable)e);
            }
            block5: for (OrientationPackage orientationPackage2 : orientationPackages) {
                List dimKeys = (List)advert2dimKeysMap.get(orientationPackage2);
                List tagDimKeys = (List)advertTagdimKeysMap.get(orientationPackage2);
                if (CollectionUtils.isNotEmpty((Collection)tagDimKeys)) {
                    Double tagFactor = this.getTagFactor(tagDimKeys, (Map<String, Double>)factorMap, orientationPackage2);
                    if (tagFactor != null) {
                        orientationPackage2.setAdjustPriceFactor(tagFactor);
                        continue;
                    }
                    dimKeys.removeAll(tagDimKeys);
                }
                for (String dimKey : dimKeys) {
                    Double factor = (Double)factorMap.get(dimKey);
                    if (!this.checkFactor(factor)) continue;
                    orientationPackage2.setAdjustPriceFactor(factor);
                    this.buildOcpxKey(dimKey, orientationPackage2, appId, slotId);
                    continue block5;
                }
            }
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private List<String> getAllHitTagKeys(OrientationPackage orientationPackage, List<String> appUserInterestList, Long appId, Long slotId) {
        ArrayList allHitTagKeys = Lists.newArrayList();
        Integer cvrType = orientationPackage.getCvrType();
        appUserInterestList.forEach(hitagId -> {
            String tagKey = RoiHashKeyUtil.getTagKey((String)hitagId, (Integer)cvrType);
            String hitTagKey = RedisKeyUtil.factorKey((Long)orientationPackage.getAdvertId(), (Long)orientationPackage.getId(), (String)tagKey);
            allHitTagKeys.add(hitTagKey);
        });
        return allHitTagKeys;
    }

    private Double getTagFactor(List<String> tagDimKeys, Map<String, Double> factorMap, OrientationPackage orientationPackage) {
        ArrayList tagFactorList = Lists.newArrayList();
        tagDimKeys.forEach(tagDimKey -> {
            Double tagFactor = (Double)factorMap.get(tagDimKey);
            if (!this.checkFactor(tagFactor)) {
                return;
            }
            String tagHitTag2 = OrientationPackageAdjustPriceFactorService.getTagHitTag(tagDimKey);
            TagFactor tf = new TagFactor(tagHitTag2, tagFactor, (String)tagDimKey);
            tagFactorList.add(tf);
        });
        if (CollectionUtils.isEmpty((Collection)tagFactorList)) {
            return null;
        }
        TagFactor maxTagFactor = tagFactorList.stream().max(Comparator.comparing(TagFactor::getFactor)).get();
        String hitTag = maxTagFactor.getTag();
        orientationPackage.setApplyUserInterestTag(hitTag);
        orientationPackage.setOcpxCrowdKey(RoiHashKeyUtil.getTagKey((String)hitTag, (Integer)orientationPackage.getCvrType()));
        return maxTagFactor.getFactor();
    }

    private void buildOcpxKey(String dimKey, OrientationPackage orientationPackage, Long appId, Long slotId) {
        if (StringUtils.isBlank((String)dimKey) || orientationPackage.getOcpxCrowdKey() != null) {
            return;
        }
        Integer cvrType = orientationPackage.getCvrType();
        if (dimKey.contains(APP)) {
            orientationPackage.setOcpxCrowdKey(RoiHashKeyUtil.getAppKey((Object)appId, (Integer)cvrType));
            return;
        }
        if (dimKey.contains(SLOT)) {
            orientationPackage.setOcpxCrowdKey(RoiHashKeyUtil.getSlotKey((Object)slotId, (Integer)cvrType));
            return;
        }
        if (dimKey.contains(DEFAULT)) {
            orientationPackage.setOcpxCrowdKey(RoiHashKeyUtil.getDefault((Integer)cvrType));
            return;
        }
    }

    private static boolean isTagWhiteByAdvertPkg(List<String> ocpxWhiteForTagList, Long advertId, Long packageId) {
        if (CollectionUtils.isEmpty(ocpxWhiteForTagList)) {
            return false;
        }
        String advertPkg = advertId + "_" + packageId;
        return ocpxWhiteForTagList.contains(advertPkg);
    }

    private static String getTagHitTag(String hitTagKey) {
        List<String> list = StringTool.getStringListByStr(hitTagKey, "_");
        if (CollectionUtils.isEmpty(list) || list.size() < 6) {
            return "";
        }
        return list.get(5);
    }

    private boolean checkFactor(Double value) {
        return value != null && !value.isNaN() && !value.equals(1.0);
    }

    class TagFactor {
        private String tag;
        private Double factor;
        private String tagKey;

        public String getTagKey() {
            return this.tagKey;
        }

        public void setTagKey(String tagKey) {
            this.tagKey = tagKey;
        }

        public String getTag() {
            return this.tag;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public Double getFactor() {
            return this.factor;
        }

        public void setFactor(Double factor) {
            this.factor = factor;
        }

        public TagFactor(String tag, Double factor, String tagKey) {
            this.tag = tag;
            this.factor = factor;
            this.tagKey = tagKey;
        }
    }
}

