/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert;

import cn.com.duiba.nezha.alg.common.model.pacing.AdvertOrientInfo;
import cn.com.duiba.nezha.alg.common.model.pacing.HelpBySelf;
import cn.com.duiba.nezha.alg.common.model.pacing.HelpBySelfParams;
import cn.com.duiba.nezha.alg.common.model.pacing.HelpMeasureResult;
import cn.com.duiba.nezha.alg.common.model.pacing.OrientInfo;
import cn.com.duiba.nezha.alg.common.model.pacing.ResultType;
import cn.com.duiba.nezha.alg.common.model.pacing.SlotRecommender;
import cn.com.duiba.nezha.alg.common.model.pacing.TagInfo;
import cn.com.duiba.nezha.alg.common.model.pacing.TrusteeshipParams;
import cn.com.duiba.nezha.engine.api.dto.FusingOrientationPackageDto;
import cn.com.duiba.nezha.engine.api.dto.RecommendAppDto;
import cn.com.duiba.nezha.engine.api.dto.RescureAppDto;
import cn.com.duiba.nezha.engine.api.dto.RescureDto;
import cn.com.duiba.nezha.engine.api.dto.RescureSlotDto;
import cn.com.duiba.nezha.engine.api.support.RecommendEngineException;
import cn.com.duiba.nezha.engine.biz.domain.AdvertStatDo;
import cn.com.duiba.nezha.engine.biz.domain.AppDo;
import cn.com.duiba.nezha.engine.biz.domain.StatisticData;
import cn.com.duiba.nezha.engine.biz.domain.advert.OrientationPackage;
import cn.com.duiba.nezha.engine.biz.entity.nezha.advert.AlgoRescureEntity;
import cn.com.duiba.nezha.engine.biz.entity.nezha.advert.SlotAdvertInfo;
import cn.com.duiba.nezha.engine.biz.service.CacheService;
import cn.com.duiba.nezha.engine.biz.support.StringTool;
import cn.com.duiba.nezha.engine.biz.vo.advert.AdvertRecommendRequestVo;
import cn.com.duiba.nezha.engine.common.utils.ListToMapTools;
import cn.com.duiba.nezha.engine.common.utils.MapUtils;
import cn.com.duiba.nezha.engine.common.utils.RedisKeyUtil;
import cn.com.duiba.nezha.engine.common.utils.StringRedisHelper;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@RefreshScope
public class TrusteeshipRecommendService
extends CacheService {
    @Value(value="${trusteeship.white}")
    private String white;
    private static final String ADVERT = "advert";
    private static final String PACKAGE = "orientation";
    private LoadingCache<String, TrusteeshipParams> trusteeshipParamsCache = CacheBuilder.newBuilder().refreshAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, TrusteeshipParams>(){

        public TrusteeshipParams load(String key) {
            return Optional.ofNullable(TrusteeshipRecommendService.this.nezhaStringRedisTemplate.opsForValue().get((Object)RedisKeyUtil.getTrusteeshipParamsKey())).map(json -> (TrusteeshipParams)JSON.parseObject((String)json, TrusteeshipParams.class)).orElseGet(TrusteeshipParams::new);
        }

        public ListenableFuture<TrusteeshipParams> reload(String key, TrusteeshipParams oldValue) throws Exception {
            ListenableFutureTask task = ListenableFutureTask.create(() -> this.load(key));
            TrusteeshipRecommendService.this.executorService.submit((Runnable)task);
            return task;
        }
    });
    private LoadingCache<String, AdvertStatDo> packageDataCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, AdvertStatDo>(){

        public AdvertStatDo load(String key) throws Exception {
            throw new IllegalAccessException("not suppose single query");
        }

        public Map<String, AdvertStatDo> loadAll(Iterable<? extends String> keys) throws Exception {
            return StringRedisHelper.of((StringRedisTemplate)TrusteeshipRecommendService.this.nezhaStringRedisTemplate).valueMultiGet(keys, AdvertStatDo.class, AdvertStatDo::new);
        }
    });
    private LoadingCache<String, SlotAdvertInfo> slotAdvertCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).recordStats().build((CacheLoader)new CacheLoader<String, SlotAdvertInfo>(){

        public SlotAdvertInfo load(String key) throws Exception {
            throw new IllegalAccessException("not suppose single query");
        }

        public Map<String, SlotAdvertInfo> loadAll(Iterable<? extends String> keys) throws Exception {
            return StringRedisHelper.of((StringRedisTemplate)TrusteeshipRecommendService.this.nezhaStringRedisTemplate).valueMultiGet(keys, SlotAdvertInfo.class, SlotAdvertInfo::new);
        }
    });
    private LoadingCache<String, AdvertStatDo> slotPackageDataCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, AdvertStatDo>(){

        public AdvertStatDo load(String key) throws Exception {
            throw new IllegalAccessException("not suppose single query");
        }

        public Map<String, AdvertStatDo> loadAll(Iterable<? extends String> keys) throws Exception {
            return StringRedisHelper.of((StringRedisTemplate)TrusteeshipRecommendService.this.nezhaStringRedisTemplate).valueMultiGet(keys, AdvertStatDo.class, AdvertStatDo::new);
        }
    });
    private LoadingCache<String, AdvertStatDo> slotAdvertDataCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, AdvertStatDo>(){

        public AdvertStatDo load(String key) throws Exception {
            throw new IllegalAccessException("not suppose single query");
        }

        public Map<String, AdvertStatDo> loadAll(Iterable<? extends String> keys) throws Exception {
            return StringRedisHelper.of((StringRedisTemplate)TrusteeshipRecommendService.this.nezhaStringRedisTemplate).valueMultiGet(keys, AdvertStatDo.class, AdvertStatDo::new);
        }
    });
    private LoadingCache<String, RescureDto> rescureOrientDataCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, RescureDto>(){

        public RescureDto load(String key) throws Exception {
            throw new IllegalAccessException("not suppose single query");
        }

        public Map<String, RescureDto> loadAll(Iterable<? extends String> keys) throws Exception {
            return StringRedisHelper.of((StringRedisTemplate)TrusteeshipRecommendService.this.nezhaStringRedisTemplate).valueMultiGet(keys, RescureDto.class, RescureDto::new);
        }
    });
    private LoadingCache<String, RescureAppDto> rescureOrientAppDataCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, RescureAppDto>(){

        public RescureAppDto load(String key) throws Exception {
            throw new IllegalAccessException("not suppose single query");
        }

        public Map<String, RescureAppDto> loadAll(Iterable<? extends String> keys) throws Exception {
            return StringRedisHelper.of((StringRedisTemplate)TrusteeshipRecommendService.this.nezhaStringRedisTemplate).valueMultiGet(keys, RescureAppDto.class, RescureAppDto::new);
        }
    });
    private LoadingCache<String, RescureSlotDto> rescureOrientSlotDataCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, RescureSlotDto>(){

        public RescureSlotDto load(String key) throws Exception {
            throw new IllegalAccessException("not suppose single query");
        }

        public Map<String, RescureSlotDto> loadAll(Iterable<? extends String> keys) throws Exception {
            return StringRedisHelper.of((StringRedisTemplate)TrusteeshipRecommendService.this.nezhaStringRedisTemplate).valueMultiGet(keys, RescureSlotDto.class, RescureSlotDto::new);
        }
    });
    private LoadingCache<String, HelpBySelfParams> helpBySelfParamsCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, HelpBySelfParams>(){

        public HelpBySelfParams load(String key) throws Exception {
            return Optional.ofNullable(TrusteeshipRecommendService.this.nezhaStringRedisTemplate.opsForValue().get((Object)key)).map(json -> (HelpBySelfParams)JSON.parseObject((String)json, HelpBySelfParams.class)).orElse(new HelpBySelfParams());
        }

        public Map<String, HelpBySelfParams> loadAll(Iterable<? extends String> keys) throws Exception {
            throw new IllegalAccessException("not suppose multi query");
        }
    });
    private LoadingCache<String, String> advertPkgTagIdCache = CacheBuilder.newBuilder().expireAfterWrite(3L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, String>(){

        public String load(String key) throws Exception {
            throw new IllegalAccessException("advertPkgTagIdCache not suppose single query");
        }

        public Map<String, String> loadAll(Iterable<? extends String> keys) throws Exception {
            ArrayList redisKeys = Lists.newArrayList(keys);
            List tagIds = TrusteeshipRecommendService.this.nezhaStringRedisTemplate.opsForValue().multiGet((Collection)redisKeys);
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)redisKeys.size());
            for (int i = 0; i < redisKeys.size(); ++i) {
                resultMap.put(redisKeys.get(i), Optional.ofNullable(tagIds.get(i)).orElse(""));
            }
            return resultMap;
        }
    });
    private LoadingCache<String, AdvertStatDo> tagStatDataCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, AdvertStatDo>(){

        public AdvertStatDo load(String key) throws Exception {
            throw new IllegalAccessException("advertPkgTagIdCache not suppose single query");
        }

        public Map<String, AdvertStatDo> loadAll(Iterable<? extends String> keys) throws Exception {
            return StringRedisHelper.of((StringRedisTemplate)TrusteeshipRecommendService.this.nezhaStringRedisTemplate).valueMultiGet(keys, AdvertStatDo.class, AdvertStatDo::new);
        }
    });

    public Set<OrientationPackage> giveUpRescurePackage(Set<OrientationPackage> orientationPackages) {
        try {
            HelpBySelfParams helpBySelfParams = (HelpBySelfParams)this.helpBySelfParamsCache.get((Object)RedisKeyUtil.getHelpbyselfParamsKey());
            if (Math.random() < 1.0E-4) {
                this.logger.info("Params helpBySelfParams", (Object)JSONObject.toJSONString((Object)helpBySelfParams));
            }
            List trusteeshipGiveUpPackages = orientationPackages.stream().filter(orientationPackage -> orientationPackage.getBasePriceException() != null && orientationPackage.getBasePriceException() == true).filter(orientationPackage -> HelpBySelf.isGiveUpBaseFlow((Long)orientationPackage.getFinalFee(), (Boolean)true, (HelpBySelfParams)helpBySelfParams)).collect(Collectors.toList());
            HashSet<OrientationPackage> allPackage = new HashSet<OrientationPackage>();
            if (trusteeshipGiveUpPackages != null) {
                this.logger.info("rescure give up package size: " + trusteeshipGiveUpPackages.size());
                allPackage.addAll(trusteeshipGiveUpPackages);
            }
            return allPackage;
        }
        catch (Exception e) {
            this.logger.error("giveUpRescurePackage error", (Throwable)e);
            return new HashSet<OrientationPackage>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OrientationPackage> recommend(Set<OrientationPackage> orientationPackages, AdvertRecommendRequestVo advertRecommendRequestVo) {
        AppDo appDo = advertRecommendRequestVo.getAppDo();
        Long appId = appDo.getId();
        Long slotId = appDo.getSlotId();
        Map<Boolean, List<OrientationPackage>> partByTargetType = orientationPackages.stream().collect(Collectors.partitioningBy(OrientationPackage::getStrongTarget));
        List strongTargetPackages = partByTargetType.getOrDefault(true, new ArrayList());
        List weakTargetOrientationPackages = partByTargetType.getOrDefault(false, new ArrayList());
        try {
            DBTimeProfile.enter((String)"handleTrusteeshipAdvert");
            Set<Object> whiteAdvertIds = StringUtils.isEmpty((Object)this.white) ? new HashSet() : Stream.of(this.white.split(",")).map(Long::parseLong).collect(Collectors.toSet());
            Set<Long> trusteeshipAdvertIds = weakTargetOrientationPackages.stream().map(OrientationPackage::getAdvertId).collect(Collectors.toSet());
            TrusteeshipParams trusteeshipParams = (TrusteeshipParams)this.trusteeshipParamsCache.getUnchecked((Object)RedisKeyUtil.getTrusteeshipParamsKey());
            Map<OrientationPackage, AdvertStatDo> packageAdvertStatDoMap = this.getPackageData(weakTargetOrientationPackages);
            Map<OrientationPackage, RescureDto> packageRescureDtoMap = this.getRescurePackageData(weakTargetOrientationPackages);
            Map<OrientationPackage, RescureAppDto> packageRescureAppDtoMap = this.getRescureAppPackageData(weakTargetOrientationPackages, appId);
            Map<OrientationPackage, RescureSlotDto> packageRescureSlotDtoMap = this.getRescureSlotPackageData(weakTargetOrientationPackages, slotId);
            Map<Long, SlotAdvertInfo> advertSlotInfoMap = this.getSlotAdvertInfo(trusteeshipAdvertIds, slotId);
            String nowTimes = LocalDate.now().format(DAY_FORMATTER);
            Map<String, AdvertStatDo> tagStatData = this.getAllTrusteeshipTagData(weakTargetOrientationPackages, appDo.getAppUserInterest(), nowTimes);
            Map<OrientationPackage, AdvertStatDo> orientationSlotDataMap = this.getSlotPackageData(weakTargetOrientationPackages, slotId);
            Map<Long, AdvertStatDo> advertSlotDataMap = this.getSlotAdvertData(trusteeshipAdvertIds, slotId);
            List trusteeshipOrientInfoList = weakTargetOrientationPackages.stream().map(orientationPackage -> {
                Integer cvrType = orientationPackage.getCvrType();
                Long advertId = orientationPackage.getAdvertId();
                SlotAdvertInfo slotAdvertInfo = (SlotAdvertInfo)advertSlotInfoMap.get(advertId);
                List<Double> biasSet = slotAdvertInfo.getBiasSet();
                List<Double> cvrSet = slotAdvertInfo.getCvrSet();
                Double cost20d = slotAdvertInfo.getCost20d();
                Double cost7d = slotAdvertInfo.getCost7d();
                Double coefficient = slotAdvertInfo.getCoefficient();
                AdvertStatDo packageStatDo = (AdvertStatDo)packageAdvertStatDoMap.get(orientationPackage);
                OrientInfo orientInfo = new OrientInfo();
                RescureDto rescureDto = (RescureDto)packageRescureDtoMap.get(orientationPackage);
                HelpMeasureResult helpMeasureResult = new HelpMeasureResult();
                helpMeasureResult.setExpand(rescureDto.getExpand());
                helpMeasureResult.setOrientRatioWeight(rescureDto.getOrientRatioWeight());
                helpMeasureResult.setIsReorient(rescureDto.getIsReorient());
                helpMeasureResult.setIsBlackRealse(rescureDto.getIsBlackRealse());
                orientInfo.setHelpMeasureResult(helpMeasureResult);
                orientInfo.setAdvertId(advertId);
                orientInfo.setOrientId(orientationPackage.getId());
                orientInfo.setCvrSet(cvrSet);
                orientInfo.setBiasSet(biasSet);
                orientInfo.setManagered(true);
                orientInfo.setCost20d(cost20d);
                orientInfo.setCost7d(cost7d);
                orientInfo.setCorrelationCoefficient(coefficient);
                orientInfo.setManageType(orientationPackage.getTargetAppLimit());
                orientInfo.setChargeType(orientationPackage.getChargeType());
                orientInfo.setTarget(orientationPackage.getConvertCost());
                orientInfo.setFee(orientationPackage.getClickFee());
                orientInfo.setAppOrientationConvert(Double.valueOf(orientationPackage.getTodayAppStatisticData().getConvertCount().doubleValue()));
                orientInfo.setAppOrientationCost(Double.valueOf(orientationPackage.getTodayAppStatisticData().getTotalConsume().doubleValue()));
                orientInfo.setOrientCostG1d(Double.valueOf(packageStatDo.getChargeFees().doubleValue()));
                orientInfo.setOrientConvertG1d(Double.valueOf(packageStatDo.getActClickCnt(cvrType).doubleValue()));
                orientInfo.setReleaseTarget(orientationPackage.getReleaseTarget());
                orientInfo.setCvrType(orientationPackage.getCvrType());
                orientInfo.setImportantAppAfee(orientationPackage.getImportantAppFee());
                orientInfo.setFuseWhite(Boolean.valueOf(whiteAdvertIds.contains(advertId)));
                RescureAppDto rescureAppDto = (RescureAppDto)packageRescureAppDtoMap.get(orientationPackage);
                orientationPackage.setFeeWeightFactor(rescureAppDto.getFeeWeightFactor());
                RescureSlotDto rescureSlotDto = (RescureSlotDto)packageRescureSlotDtoMap.get(orientationPackage);
                orientationPackage.setFeeWeightFactor(rescureSlotDto.getFeeWeightFactor());
                orientationPackage.setBasePriceException(rescureSlotDto.getBasePriceException());
                if (rescureAppDto.getFeeWeightFactor() != null && rescureSlotDto.getFeeWeightFactor() != null) {
                    orientationPackage.setFeeWeightFactor(Math.max(rescureAppDto.getFeeWeightFactor(), rescureSlotDto.getFeeWeightFactor()));
                }
                AlgoRescureEntity algoRescureEntity = this.getRescureEntity(rescureDto, rescureSlotDto, rescureAppDto);
                orientationPackage.setAlgoRescureEntity(algoRescureEntity);
                Optional.ofNullable(orientationPackage.getRecently7DayStatisticData()).map(statisticData -> statisticData.getTotalConsume().doubleValue()).ifPresent(arg_0 -> ((OrientInfo)orientInfo).setOrientCostG7d(arg_0));
                Optional.ofNullable(orientationPackage.getTodayAppStatisticData()).map(StatisticData::getCvr).ifPresent(arg_0 -> ((OrientInfo)orientInfo).setAppOrientCvrDay(arg_0));
                Optional.ofNullable(orientationSlotDataMap.get(orientationPackage)).ifPresent(slotPackageData -> {
                    orientInfo.setSlotOrientationConvert(Double.valueOf(slotPackageData.getActClickCnt(cvrType).doubleValue()));
                    orientInfo.setSlotOrientationCost(Double.valueOf(slotPackageData.getChargeFees().doubleValue()));
                });
                Optional.ofNullable(advertSlotDataMap.get(advertId)).ifPresent(slotAdvertData -> {
                    orientInfo.setSlotAdvertConvert(Double.valueOf(slotAdvertData.getActClickCnt(cvrType).doubleValue()));
                    orientInfo.setSlotAdvertCost(Double.valueOf(slotAdvertData.getChargeFees().doubleValue()));
                });
                Map<String, List<TagInfo>> tagRtPreformanceMap = this.bulidTagAdvertStat((OrientationPackage)orientationPackage, tagStatData, nowTimes);
                orientInfo.setTagRtPerformance(tagRtPreformanceMap);
                orientInfo.setStatAdCtr(orientationPackage.getStatCtr());
                orientInfo.setStatAdCvr(orientationPackage.getStatCvr());
                return orientInfo;
            }).collect(Collectors.toList());
            Map trusteeshipRecommendResult = SlotRecommender.recommend(trusteeshipOrientInfoList, (Long)slotId, (TrusteeshipParams)trusteeshipParams);
            Map packageMap = ListToMapTools.toMap((Collection)weakTargetOrientationPackages, orientationPackage -> new AdvertOrientInfo(orientationPackage.getAdvertId(), orientationPackage.getId()), Function.identity());
            List trusteeshipOnTargetPackages = ((Collection)trusteeshipRecommendResult.getOrDefault(ResultType.ONTARGET, new ArrayList())).stream().map(advertOrientInfo -> {
                OrientationPackage orientationPackage = (OrientationPackage)packageMap.get(advertOrientInfo);
                orientationPackage.setMatchType(advertOrientInfo.getMatchType());
                return orientationPackage;
            }).collect(Collectors.toList());
            this.logger.info("\u7b97\u6cd5\u63a8\u8350\u7684\u51fa\u6765\u7684\u5f31\u5b9a\u5411\u914d\u7f6e:" + JSONObject.toJSONString(trusteeshipOnTargetPackages));
            List trusteeshipGiveUpPackages = ((Collection)trusteeshipRecommendResult.getOrDefault(ResultType.GIVEUP, new ArrayList())).stream().map(packageMap::get).collect(Collectors.toList());
            this.handlerTrusteeshipResult(appId, advertRecommendRequestVo, trusteeshipRecommendResult);
            HashSet<OrientationPackage> allPackage = new HashSet<OrientationPackage>(strongTargetPackages);
            allPackage.addAll(trusteeshipOnTargetPackages);
            allPackage.addAll(trusteeshipGiveUpPackages);
            allPackage.forEach(orientationPackage -> orientationPackage.setSmartShop(trusteeshipGiveUpPackages.contains(orientationPackage)));
            HashSet<OrientationPackage> hashSet = allPackage;
            return hashSet;
        }
        catch (Exception e) {
            this.logger.error("handleTrusteeshipAdvert error", (Throwable)e);
            HashSet<OrientationPackage> hashSet = new HashSet<OrientationPackage>(strongTargetPackages);
            return hashSet;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private AlgoRescureEntity getRescureEntity(RescureDto rescureDto, RescureSlotDto rescureSlotDto, RescureAppDto rescureAppDto) {
        AlgoRescureEntity algoRescureEntity = new AlgoRescureEntity();
        Optional.ofNullable(rescureDto.getExpand()).ifPresent(obj -> {
            algoRescureEntity.setCostException(rescureDto.getCostException());
            algoRescureEntity.setCostConvertException(rescureDto.getCostConvertException());
            algoRescureEntity.setFatalException(rescureDto.getFatalException());
            algoRescureEntity.setHelpBySelfType(rescureDto.getHelpBySelfType());
            algoRescureEntity.setExpand(rescureDto.getExpand());
            algoRescureEntity.setOrientRatioWeight(rescureDto.getOrientRatioWeight());
            algoRescureEntity.setIsReorient(rescureDto.getIsReorient());
            algoRescureEntity.setIsBlackRealse(rescureDto.getIsBlackRealse());
            algoRescureEntity.setRemindAE1(rescureDto.getRemindAE());
            algoRescureEntity.setResetStableFactor(rescureDto.getResetStableFactor());
        });
        Optional.ofNullable(rescureSlotDto.getBasePriceException()).ifPresent(obj -> {
            algoRescureEntity.setFeeWeightFactor0(rescureSlotDto.getFeeWeightFactor());
            algoRescureEntity.setBasePriceException(rescureSlotDto.getBasePriceException());
            algoRescureEntity.setRemindAE2(rescureSlotDto.getRemindAE());
        });
        Optional.ofNullable(rescureAppDto.getCancelStableRelate()).ifPresent(obj -> {
            algoRescureEntity.setFeeWeightFactor1(rescureAppDto.getFeeWeightFactor());
            algoRescureEntity.setCancelStableRelate(rescureAppDto.getCancelStableRelate());
        });
        return algoRescureEntity;
    }

    private Map<OrientationPackage, AdvertStatDo> getPackageData(Collection<OrientationPackage> weakTargetOrientationPackages) {
        try {
            DBTimeProfile.enter((String)"getPackageData");
            Map packageKeysMap = ListToMapTools.toMap(weakTargetOrientationPackages, Function.identity(), orientationPackage -> RedisKeyUtil.getOrientationPackageData((Long)orientationPackage.getAdvertId(), (Long)orientationPackage.getId(), (String)LocalDate.now().format(DAY_FORMATTER)));
            Map map = MapUtils.translate((Map)packageKeysMap, (Map)this.packageDataCache.getAll(packageKeysMap.values()));
            return map;
        }
        catch (ExecutionException e) {
            throw new RecommendEngineException("getPackageData error", (Exception)e);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private Map<OrientationPackage, RescureDto> getRescurePackageData(Collection<OrientationPackage> weakTargetOrientationPackages) {
        try {
            DBTimeProfile.enter((String)"getRescurePackageData");
            Map packageRescureKeysMap = ListToMapTools.toMap(weakTargetOrientationPackages, Function.identity(), orientationPackage -> RedisKeyUtil.getNezhaRescureKey((Long)orientationPackage.getAdvertId(), (Long)orientationPackage.getId()));
            Map map = MapUtils.translate((Map)packageRescureKeysMap, (Map)this.rescureOrientDataCache.getAll(packageRescureKeysMap.values()));
            return map;
        }
        catch (ExecutionException e) {
            throw new RecommendEngineException("getRescurePackageData error", (Exception)e);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private Map<OrientationPackage, RescureAppDto> getRescureAppPackageData(Collection<OrientationPackage> weakTargetOrientationPackages, Long appId) {
        try {
            DBTimeProfile.enter((String)"getRescureAppPackageData");
            Map packageRescureKeysMap = ListToMapTools.toMap(weakTargetOrientationPackages, Function.identity(), orientationPackage -> RedisKeyUtil.getNezhaRescureAppKey((Long)orientationPackage.getAdvertId(), (Long)orientationPackage.getId(), (Long)appId));
            Map map = MapUtils.translate((Map)packageRescureKeysMap, (Map)this.rescureOrientAppDataCache.getAll(packageRescureKeysMap.values()));
            return map;
        }
        catch (ExecutionException e) {
            throw new RecommendEngineException("getRescureAppPackageData error", (Exception)e);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private Map<OrientationPackage, RescureSlotDto> getRescureSlotPackageData(Collection<OrientationPackage> weakTargetOrientationPackages, Long slotId) {
        try {
            DBTimeProfile.enter((String)"getRescureSlotPackageData");
            Map packageRescureKeysMap = ListToMapTools.toMap(weakTargetOrientationPackages, Function.identity(), orientationPackage -> RedisKeyUtil.getNezhaRescureSlotKey((Long)orientationPackage.getAdvertId(), (Long)orientationPackage.getId(), (Long)slotId));
            Map map = MapUtils.translate((Map)packageRescureKeysMap, (Map)this.rescureOrientSlotDataCache.getAll(packageRescureKeysMap.values()));
            return map;
        }
        catch (ExecutionException e) {
            throw new RecommendEngineException("getRescureSlotPackageData error", (Exception)e);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private Map<Long, SlotAdvertInfo> getSlotAdvertInfo(Collection<Long> advertIds, Long slotId) {
        try {
            DBTimeProfile.enter((String)"AdvertStatService.getSlotAdvertInfo");
            Map advertKeyMap = ListToMapTools.toMap(advertIds, Function.identity(), advertId -> RedisKeyUtil.getSlotAdvertInfoKey((Long)slotId, (Long)advertId));
            ImmutableMap keySlotAdvertInfoMap = this.slotAdvertCache.getAll(advertKeyMap.values());
            Map map = MapUtils.translate((Map)advertKeyMap, (Map)keySlotAdvertInfoMap);
            return map;
        }
        catch (Exception e) {
            throw new RecommendEngineException("getSlotAdvertInfo error", e);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private Map<OrientationPackage, AdvertStatDo> getSlotPackageData(Collection<OrientationPackage> trusteeshipOrientationPackages, Long slotId) {
        try {
            DBTimeProfile.enter((String)"AdvertStatService.getSlotPackageData");
            String todayDate = LocalDate.now().format(DAY_FORMATTER);
            Map orientationPackageKeyMap = ListToMapTools.toMap(trusteeshipOrientationPackages, Function.identity(), orientationPackage -> RedisKeyUtil.getSlotPackageDataKey((Long)slotId, (Long)orientationPackage.getAdvertId(), (Long)orientationPackage.getId(), (Long)orientationPackage.getConvertCost(), (String)todayDate));
            Map map = MapUtils.translate((Map)orientationPackageKeyMap, (Map)this.slotPackageDataCache.getAll(orientationPackageKeyMap.values()));
            return map;
        }
        catch (ExecutionException e) {
            throw new RecommendEngineException("getSlotPackageBlackInfo error", (Exception)e);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private Map<Long, AdvertStatDo> getSlotAdvertData(Collection<Long> advertIds, Long slotId) {
        try {
            DBTimeProfile.enter((String)"AdvertStatService.getSlotPackageData");
            String todayDate = LocalDate.now().format(DAY_FORMATTER);
            Map advertIdKeyMap = ListToMapTools.toMap(advertIds, Function.identity(), advertId -> RedisKeyUtil.getSlotAdvertDataKey((Long)slotId, (Long)advertId, (String)todayDate));
            Map map = MapUtils.translate((Map)advertIdKeyMap, (Map)this.slotAdvertDataCache.getAll(advertIdKeyMap.values()));
            return map;
        }
        catch (ExecutionException e) {
            throw new RecommendEngineException("getSlotPackageBlackInfo error", (Exception)e);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private Map<String, AdvertStatDo> getAllTrusteeshipTagData(Collection<OrientationPackage> trusteeshipOrientationPackages, String appUserInterest, String nowTimes) {
        Set<String> appUserInterestSet = StringTool.getStringSetByStr(appUserInterest, "_");
        if (CollectionUtils.isEmpty(trusteeshipOrientationPackages) || CollectionUtils.isEmpty(appUserInterestSet)) {
            return Maps.newHashMap();
        }
        this.getUserinterestTagByPackage(trusteeshipOrientationPackages, appUserInterestSet);
        List<OrientationPackage> tagOrientationPackages = trusteeshipOrientationPackages.stream().filter(pkg -> CollectionUtils.isNotEmpty(pkg.getHitUserInterest())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(tagOrientationPackages)) {
            return Maps.newHashMap();
        }
        return this.getTagStatData(tagOrientationPackages, nowTimes);
    }

    private Map<String, AdvertStatDo> getTagStatData(List<OrientationPackage> tagOrientationPackages, String nowTimes) {
        try {
            HashSet tagAdvertRedisKeySet = new HashSet();
            HashSet tagPkgRedisKeySet = new HashSet();
            tagOrientationPackages.forEach(tagPkg -> {
                Long advertId = tagPkg.getAdvertId();
                Long pkgId = tagPkg.getId();
                Long convertCost = tagPkg.getConvertCost();
                tagPkg.getHitUserInterest().forEach(tag -> {
                    String tagAdvertRedisKey = RedisKeyUtil.getOcpaTagDataKey((Long)advertId, null, null, (String)tag, (String)nowTimes);
                    String tagPkgRedisKey = RedisKeyUtil.getOcpaTagDataKey((Long)advertId, (Long)pkgId, (Long)convertCost, (String)tag, (String)nowTimes);
                    tagAdvertRedisKeySet.add(tagAdvertRedisKey);
                    tagPkgRedisKeySet.add(tagPkgRedisKey);
                });
            });
            ArrayList allTagKeys = Lists.newArrayList();
            allTagKeys.addAll(tagAdvertRedisKeySet);
            allTagKeys.addAll(tagPkgRedisKeySet);
            return this.tagStatDataCache.getAll((Iterable)allTagKeys);
        }
        catch (Exception e) {
            this.logger.info("getPackageTagData is error:" + e);
            return Maps.newHashMap();
        }
    }

    private Map<String, List<TagInfo>> bulidTagAdvertStat(OrientationPackage tagOrientationPackage, Map<String, AdvertStatDo> tagStatdataMap, String nowTimes) {
        Set<String> hitUserInterest = tagOrientationPackage.getHitUserInterest();
        if (CollectionUtils.isEmpty(hitUserInterest)) {
            return Maps.newHashMap();
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)2);
        HashSet advertTagInfoList = Sets.newHashSet();
        HashSet packageTagInfoList = Sets.newHashSet();
        Long advertId = tagOrientationPackage.getAdvertId();
        Long pkgId = tagOrientationPackage.getId();
        Long convertCost = tagOrientationPackage.getConvertCost();
        Integer cvrType = Optional.ofNullable(tagOrientationPackage.getCvrType()).orElse(0);
        hitUserInterest.forEach(tag -> {
            String tagAdvertRedisKey = RedisKeyUtil.getOcpaTagDataKey((Long)advertId, null, null, (String)tag, (String)nowTimes);
            String tagPkgRedisKey = RedisKeyUtil.getOcpaTagDataKey((Long)advertId, (Long)pkgId, (Long)convertCost, (String)tag, (String)nowTimes);
            AdvertStatDo advertStatDo = Optional.ofNullable(tagStatdataMap.get(tagAdvertRedisKey)).orElse(new AdvertStatDo());
            AdvertStatDo pkgStatDo = Optional.ofNullable(tagStatdataMap.get(tagPkgRedisKey)).orElse(new AdvertStatDo());
            TagInfo advertTagInfo = new TagInfo(advertId, null, tag, advertStatDo.getChargeCnt(), advertStatDo.getActClickCnt(cvrType), advertStatDo.getChargeFees());
            TagInfo pkgTagInfo = new TagInfo(advertId, pkgId, tag, pkgStatDo.getChargeCnt(), pkgStatDo.getActClickCnt(cvrType), pkgStatDo.getChargeFees());
            advertTagInfoList.add(advertTagInfo);
            packageTagInfoList.add(pkgTagInfo);
        });
        resultMap.put(ADVERT, Lists.newArrayList((Iterable)advertTagInfoList));
        resultMap.put(PACKAGE, Lists.newArrayList((Iterable)packageTagInfoList));
        return resultMap;
    }

    private void getUserinterestTagByPackage(Collection<OrientationPackage> trusteeshipOrientationPackages, Set<String> appUserInterestSet) {
        try {
            ArrayList tagKey = new ArrayList(trusteeshipOrientationPackages.size());
            trusteeshipOrientationPackages.forEach(pkg -> {
                Long advertId = pkg.getAdvertId();
                Long pkgId = pkg.getId();
                String redisKey = RedisKeyUtil.getOcpaTagKey((Long)advertId, (Long)pkgId);
                tagKey.add(redisKey);
            });
            ImmutableMap advertPackageTagMap = this.advertPkgTagIdCache.getAll(tagKey);
            trusteeshipOrientationPackages.forEach(arg_0 -> TrusteeshipRecommendService.lambda$getUserinterestTagByPackage$24((Map)advertPackageTagMap, appUserInterestSet, arg_0));
        }
        catch (Exception e) {
            this.logger.info("getUserinterestTagByPackage is error", (Throwable)e);
        }
    }

    private void handlerTrusteeshipResult(Long appId, AdvertRecommendRequestVo advertRecommendRequestVo, Map<ResultType, Collection<AdvertOrientInfo>> trusteeshipRecommendResult) {
        Set<FusingOrientationPackageDto> fuse1PackageDto = ((Collection)trusteeshipRecommendResult.getOrDefault(ResultType.FUSE1, new ArrayList())).stream().map(advertOrientInfo -> this.convert((AdvertOrientInfo)advertOrientInfo, 2)).collect(Collectors.toSet());
        Set fuse2PackageDto = ((Collection)trusteeshipRecommendResult.getOrDefault(ResultType.FUSE2, new ArrayList())).stream().map(advertOrientInfo -> this.convert((AdvertOrientInfo)advertOrientInfo, 1)).collect(Collectors.toSet());
        fuse1PackageDto.addAll(fuse2PackageDto);
        advertRecommendRequestVo.setFusingOrientationPackages(fuse1PackageDto);
        Set<RecommendAppDto> recommendTargetAppDto = ((Collection)trusteeshipRecommendResult.getOrDefault(ResultType.ORIENT, new ArrayList())).stream().map(advertOrientInfo -> this.convert((AdvertOrientInfo)advertOrientInfo, appId, 1)).collect(Collectors.toSet());
        Set recommendLimitAppDto = ((Collection)trusteeshipRecommendResult.getOrDefault(ResultType.SHIELD, new ArrayList())).stream().map(advertOrientInfo -> this.convert((AdvertOrientInfo)advertOrientInfo, appId, 2)).collect(Collectors.toSet());
        recommendTargetAppDto.addAll(recommendLimitAppDto);
        advertRecommendRequestVo.setRecommendApps(recommendTargetAppDto);
    }

    private RecommendAppDto convert(AdvertOrientInfo advertOrientInfo, Long appId, Integer type) {
        RecommendAppDto recommendAppDto = new RecommendAppDto();
        recommendAppDto.setAdvertId(advertOrientInfo.getAdvertId());
        recommendAppDto.setAppId(appId);
        recommendAppDto.setPackageId(advertOrientInfo.getOrientId());
        recommendAppDto.setBias(advertOrientInfo.getCostConvertBias());
        recommendAppDto.setType(type);
        return recommendAppDto;
    }

    private FusingOrientationPackageDto convert(AdvertOrientInfo advertOrientInfo, Integer type) {
        FusingOrientationPackageDto fusingOrientationPackageDto = new FusingOrientationPackageDto();
        fusingOrientationPackageDto.setType(type);
        fusingOrientationPackageDto.setId(advertOrientInfo.getOrientId());
        fusingOrientationPackageDto.setAdvertId(advertOrientInfo.getAdvertId());
        return fusingOrientationPackageDto;
    }

    private static /* synthetic */ void lambda$getUserinterestTagByPackage$24(Map advertPackageTagMap, Set appUserInterestSet, OrientationPackage pkg) {
        Long advertId = pkg.getAdvertId();
        Long pkgId = pkg.getId();
        String redisKey = RedisKeyUtil.getOcpaTagKey((Long)advertId, (Long)pkgId);
        String pkgUserInterests = (String)advertPackageTagMap.get(redisKey);
        Set<String> pkgUserInterestSet = StringTool.getStringSetByStr(pkgUserInterests, "_");
        pkgUserInterestSet.retainAll(appUserInterestSet);
        if (CollectionUtils.isNotEmpty(pkgUserInterestSet)) {
            Set<String> hitUserInterest = Optional.ofNullable(pkg.getHitUserInterest()).orElse(Sets.newHashSet());
            hitUserInterest.addAll(pkgUserInterestSet);
            pkg.setHitUserInterest(hitUserInterest);
        }
    }
}

