/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert.ctr;

import cn.com.duiba.nezha.engine.biz.domain.advert.Advert;
import cn.com.duiba.nezha.engine.biz.domain.mergeData.MergeData;
import cn.com.duiba.nezha.engine.biz.enums.MergeDataType;
import cn.com.duiba.nezha.engine.biz.service.CacheService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public interface AdvertMergeStatService {
    public List<MergeData> getMaterialDataInApp(Long var1, Long var2, List<Long> var3);

    public Map<MergeDataType, List<MergeData>> getAdvertAndAppData(Collection<Advert> var1, Long var2);

    public Map<String, CacheService.CacheInfo> getCacheInfo();

    public static class AdvertMergeDataQuery {
        private Long advertId;
        private Long materialId;
        private Long appId;
        private Long times;

        public Long getAdvertId() {
            return this.advertId;
        }

        public Long getMaterialId() {
            return this.materialId;
        }

        public Long getAppId() {
            return this.appId;
        }

        public Long getTimes() {
            return this.times;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AdvertMergeDataQuery that = (AdvertMergeDataQuery)o;
            return Objects.equals(this.advertId, that.advertId) && Objects.equals(this.materialId, that.materialId) && Objects.equals(this.appId, that.appId) && Objects.equals(this.times, that.times);
        }

        public int hashCode() {
            return Objects.hash(this.advertId, this.materialId, this.appId, this.times);
        }

        private AdvertMergeDataQuery(Builder builder) {
            this.advertId = builder.advertId;
            this.materialId = builder.materialId;
            this.appId = builder.appId;
            this.times = builder.times;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static final class Builder {
            private Long advertId;
            private Long materialId;
            private Long appId;
            private Long times;

            private Builder() {
            }

            public Builder advertId(Long val) {
                this.advertId = val;
                return this;
            }

            public Builder materialId(Long val) {
                this.materialId = val;
                return this;
            }

            public Builder appId(Long val) {
                this.appId = val;
                return this;
            }

            public Builder times(Long val) {
                this.times = val;
                return this;
            }

            public AdvertMergeDataQuery build() {
                return new AdvertMergeDataQuery(this);
            }
        }
    }
}

