/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert.ctr.impl;

import cn.com.duiba.nezha.alg.alg.correct.ModelPredCorrect;
import cn.com.duiba.nezha.alg.alg.correct.ModelPredRectifier;
import cn.com.duiba.nezha.alg.alg.vo.CorrectionInfo;
import cn.com.duiba.nezha.alg.alg.vo.NezhaStatDto;
import cn.com.duiba.nezha.alg.model.enums.PredictResultType;
import cn.com.duiba.nezha.engine.api.enums.AdvertAlgEnum;
import cn.com.duiba.nezha.engine.api.enums.PredictCorrectType;
import cn.com.duiba.nezha.engine.api.enums.RedisKey;
import cn.com.duiba.nezha.engine.biz.domain.CorrectResult;
import cn.com.duiba.nezha.engine.biz.domain.FeatureIndex;
import cn.com.duiba.nezha.engine.biz.domain.advert.Advert;
import cn.com.duiba.nezha.engine.biz.service.advert.ctr.AdvertPredictCorrectService;
import cn.com.duiba.nezha.engine.biz.vo.advert.AdvertRecommendRequestVo;
import cn.com.duiba.nezha.engine.common.utils.ListToMapTools;
import cn.com.duiba.nezha.engine.common.utils.MapUtils;
import cn.com.duiba.nezha.engine.common.utils.RedisKeyUtil;
import cn.com.duiba.nezha.engine.common.utils.StringRedisHelper;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class AdvertPredictCorrectServiceImpl
implements AdvertPredictCorrectService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertPredictCorrectServiceImpl.class);
    @Resource
    private StringRedisTemplate nezhaStringRedisTemplate;
    private LoadingCache<String, NezhaStatDto> cache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, NezhaStatDto>(){

        public NezhaStatDto load(String key) throws Exception {
            throw new IllegalAccessException("not suppose single query");
        }

        public Map<String, NezhaStatDto> loadAll(Iterable<? extends String> keys) {
            return StringRedisHelper.of((StringRedisTemplate)AdvertPredictCorrectServiceImpl.this.nezhaStringRedisTemplate).valueMultiGet(keys, NezhaStatDto.class, NezhaStatDto::new);
        }
    });

    @Override
    public CorrectResult correct(AdvertRecommendRequestVo advertRecommendRequestVo, Map<PredictResultType, Map<FeatureIndex, Double>> advertPredictValueMap) {
        PredictCorrectType correctType = advertRecommendRequestVo.getPredictCorrectType();
        AdvertAlgEnum advertAlgEnum = advertRecommendRequestVo.getAdvertAlgEnum();
        Collection<Advert> adverts = advertRecommendRequestVo.getAdvertMap().values();
        Long appId = advertRecommendRequestVo.getAppDo().getId();
        Long slotId = advertRecommendRequestVo.getAppDo().getSlotId();
        Map<Long, NezhaStatDto> nezhaStatDtoMap = correctType.equals((Object)PredictCorrectType.CORRECT) || correctType.equals((Object)PredictCorrectType.CORRECT_REFACTOR) ? this.loadNezhaStatDto(advertAlgEnum, adverts, appId) : this.loadNezhaStatDto(correctType, advertAlgEnum, adverts, appId, slotId);
        advertRecommendRequestVo.setNezhaStatDtoMap(nezhaStatDtoMap);
        HashMap<PredictResultType, Map<Long, Double>> typeReconstructionFactorMap = new HashMap<PredictResultType, Map<Long, Double>>();
        HashMap<PredictResultType, Map<Long, Double>> typeCorrectionFactorMap = new HashMap<PredictResultType, Map<Long, Double>>();
        advertPredictValueMap.forEach((typeEnum, predictValueMap) -> {
            DBTimeProfile.enter((String)("start " + typeEnum.toString() + " Correct"));
            HashMap reconstructionFactorMap = new HashMap();
            HashMap correctionFactorMap = new HashMap();
            try {
                predictValueMap.keySet().forEach(featureIndex -> {
                    Long advertId = featureIndex.getAdvertId();
                    Optional.ofNullable(nezhaStatDtoMap.get(advertId)).ifPresent(nezhaStatDto -> {
                        Double predictValue = (Double)predictValueMap.get(featureIndex);
                        CorrectionInfo correctionInfo = new CorrectionInfo();
                        correctionInfo.setAdvertId(advertId);
                        correctionInfo.setType(Long.valueOf(typeEnum == PredictResultType.CTR ? 1L : 2L));
                        correctionInfo.setCurrentPreValue(predictValue);
                        correctionInfo.setNezhaStatDto(nezhaStatDto);
                        try {
                            if (correctType == PredictCorrectType.CORRECT) {
                                ModelPredRectifier.getCorrectionFactor((CorrectionInfo)correctionInfo);
                            } else if (correctType == PredictCorrectType.CORRECT_REFACTOR) {
                                ModelPredRectifier.getCorrectionReconstructionFactor((CorrectionInfo)correctionInfo);
                            } else {
                                ModelPredCorrect.getCorrectionFactor((CorrectionInfo)correctionInfo);
                            }
                            Double correctionFactor = correctionInfo.getCorrectionFactor();
                            Double reconstructionFactor = correctionInfo.getReconstructionFactor();
                            double correctValue = predictValueMap.getOrDefault(featureIndex, 0.0) * correctionFactor;
                            predictValueMap.put(featureIndex, correctValue);
                            reconstructionFactorMap.put(advertId, reconstructionFactor);
                            correctionFactorMap.put(advertId, correctionFactor);
                        }
                        catch (Exception e) {
                            LOGGER.error("Correct error", (Throwable)e);
                        }
                    });
                });
                typeReconstructionFactorMap.put((PredictResultType)typeEnum, reconstructionFactorMap);
                typeCorrectionFactorMap.put((PredictResultType)typeEnum, correctionFactorMap);
            }
            finally {
                DBTimeProfile.release();
            }
        });
        return CorrectResult.newBuilder().nezhaStatDtoMap(nezhaStatDtoMap).correctionFactorMap(typeCorrectionFactorMap).reconstructionFactorMap(typeReconstructionFactorMap).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, NezhaStatDto> loadNezhaStatDto(PredictCorrectType correctType, AdvertAlgEnum advertAlgEnum, Collection<Advert> advertIds, Long appId, Long slotId) {
        RedisKey redisKey = correctType.equals((Object)PredictCorrectType.CORRECT_NEW1) ? RedisKey.K67 : RedisKey.K68;
        try {
            DBTimeProfile.enter((String)"loadNezhaStatDto");
            Map advertIdKeyMap = ListToMapTools.toMap(advertIds, Advert::getId, advert -> RedisKeyUtil.getNezhaStatKey((RedisKey)redisKey, (Long)advertAlgEnum.getType().longValue(), (Long)advert.getId(), (Long)appId, (Long)slotId));
            Map map = MapUtils.translate((Map)advertIdKeyMap, (Map)this.cache.getAll(advertIdKeyMap.values()));
            return map;
        }
        catch (Exception e) {
            LOGGER.warn("loadNezhaStatDto happened error:{}", (Throwable)e);
            HashMap<Long, NezhaStatDto> hashMap = new HashMap<Long, NezhaStatDto>();
            return hashMap;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, NezhaStatDto> loadNezhaStatDto(AdvertAlgEnum advertAlgEnum, Collection<Advert> adverts, Long appId) {
        try {
            DBTimeProfile.enter((String)"loadNezhaStatDto");
            Map advertIdKeyMap = ListToMapTools.toMap(adverts, Advert::getId, advert -> RedisKeyUtil.getNezhaStatKey((Long)advertAlgEnum.getType().longValue(), (Long)advert.getId(), (Long)appId));
            Map map = MapUtils.translate((Map)advertIdKeyMap, (Map)this.cache.getAll(advertIdKeyMap.values()));
            return map;
        }
        catch (Exception e) {
            LOGGER.warn("loadNezhaStatDto happened error:{}", (Throwable)e);
            HashMap<Long, NezhaStatDto> hashMap = new HashMap<Long, NezhaStatDto>();
            return hashMap;
        }
        finally {
            DBTimeProfile.release();
        }
    }
}

