/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert.ctr.impl;

import cn.com.duiba.nezha.engine.api.support.RecommendEngineException;
import cn.com.duiba.nezha.engine.biz.domain.StatisticData;
import cn.com.duiba.nezha.engine.biz.service.CacheService;
import cn.com.duiba.nezha.engine.biz.service.advert.ctr.AdvertStatService;
import cn.com.duiba.nezha.engine.common.utils.ListToMapTools;
import cn.com.duiba.nezha.engine.common.utils.MapUtils;
import cn.com.duiba.nezha.engine.common.utils.RedisKeyUtil;
import cn.com.duiba.nezha.engine.common.utils.StringRedisHelper;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class AdvertStatServiceImpl
extends CacheService
implements AdvertStatService {
    private static final CacheService.CacheDuration HOURLY_STAT_CACHE_DURATION = new CacheService.CacheDuration(12L, TimeUnit.HOURS);
    private static final CacheService.CacheDuration DAILY_STAT_CACHE_DURATION = new CacheService.CacheDuration(1L, TimeUnit.DAYS);
    private static final CacheService.CacheDuration CURRENT_DAY_STAT_CACHE_DURATION = new CacheService.CacheDuration(1L, TimeUnit.MINUTES);
    private static final CacheService.CacheDuration CURRENT_HOUR_STAT_CACHE_DURATION = new CacheService.CacheDuration(90L, TimeUnit.SECONDS);
    private LoadingCache<String, StatisticData> hourlyStatCache = CacheBuilder.newBuilder().expireAfterWrite(HOURLY_STAT_CACHE_DURATION.getDuration().longValue(), HOURLY_STAT_CACHE_DURATION.getTimeUnit()).recordStats().build((CacheLoader)new CacheLoader<String, StatisticData>(){

        public StatisticData load(String key) throws Exception {
            throw new IllegalAccessException("not suppose single query");
        }

        public Map<String, StatisticData> loadAll(Iterable<? extends String> keys) throws Exception {
            DBTimeProfile.enter((String)"loadAdvertHourlyStat");
            Map key2Stat = StringRedisHelper.of((StringRedisTemplate)AdvertStatServiceImpl.this.nezhaStringRedisTemplate).valueMultiGet(keys, StatisticData.class, StatisticData::new);
            DBTimeProfile.release();
            return key2Stat;
        }
    });
    private LoadingCache<String, StatisticData> dailyStatCache = CacheBuilder.newBuilder().expireAfterWrite(DAILY_STAT_CACHE_DURATION.getDuration().longValue(), DAILY_STAT_CACHE_DURATION.getTimeUnit()).recordStats().build((CacheLoader)new CacheLoader<String, StatisticData>(){

        public StatisticData load(String key) throws Exception {
            throw new IllegalAccessException("not suppose single query");
        }

        public Map<String, StatisticData> loadAll(Iterable<? extends String> keys) throws Exception {
            return StringRedisHelper.of((StringRedisTemplate)AdvertStatServiceImpl.this.nezhaStringRedisTemplate).valueMultiGet(keys, StatisticData.class, StatisticData::new);
        }
    });
    private LoadingCache<String, StatisticData> currentDayStatCache = CacheBuilder.newBuilder().expireAfterWrite(CURRENT_DAY_STAT_CACHE_DURATION.getDuration().longValue(), CURRENT_DAY_STAT_CACHE_DURATION.getTimeUnit()).recordStats().build((CacheLoader)new CacheLoader<String, StatisticData>(){

        public StatisticData load(String key) throws Exception {
            throw new IllegalAccessException("not suppose single query");
        }

        public Map<String, StatisticData> loadAll(Iterable<? extends String> keys) throws Exception {
            return StringRedisHelper.of((StringRedisTemplate)AdvertStatServiceImpl.this.nezhaStringRedisTemplate).valueMultiGet(keys, StatisticData.class, StatisticData::new);
        }
    });
    private LoadingCache<String, StatisticData> currentHourStatCache = CacheBuilder.newBuilder().expireAfterWrite(CURRENT_HOUR_STAT_CACHE_DURATION.getDuration().longValue(), CURRENT_HOUR_STAT_CACHE_DURATION.getTimeUnit()).recordStats().build((CacheLoader)new CacheLoader<String, StatisticData>(){

        public StatisticData load(String key) throws Exception {
            throw new IllegalAccessException("not suppose single query");
        }

        public Map<String, StatisticData> loadAll(Iterable<? extends String> keys) throws Exception {
            return StringRedisHelper.of((StringRedisTemplate)AdvertStatServiceImpl.this.nezhaStringRedisTemplate).valueMultiGet(keys, StatisticData.class, StatisticData::new);
        }
    });
    private LoadingCache<AdvertStatService.Query, StatisticData> daily6StatCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).recordStats().build((CacheLoader)new CacheLoader<AdvertStatService.Query, StatisticData>(){

        public StatisticData load(AdvertStatService.Query key) throws Exception {
            throw new IllegalAccessException("not suppose single query");
        }

        public Map<AdvertStatService.Query, StatisticData> loadAll(Iterable<? extends AdvertStatService.Query> keys) throws Exception {
            String dayTimestamp = LocalDateTime.now().format(DAY_FORMATTER);
            Map query2TimestampListMap = ListToMapTools.toMap((Collection)Lists.newArrayList(keys), Function.identity(), v -> AdvertStatServiceImpl.this.getQueryKey(dayTimestamp, v));
            List allKeys = query2TimestampListMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            ImmutableMap timestamp2Stat = AdvertStatServiceImpl.this.dailyStatCache.getAll(allKeys);
            return ListToMapTools.toMap(query2TimestampListMap.entrySet(), Map.Entry::getKey, entry -> AdvertStatServiceImpl.this.sum(((List)entry.getValue()).stream().map(arg_0 -> ((ImmutableMap)timestamp2Stat).get(arg_0)).collect(Collectors.toList())));
        }
    });

    private List<String> getQueryKey(String dayTimestamp, AdvertStatService.Query query) {
        List last6DayTimestamps = (List)this.last6DayTimestampCache.getUnchecked((Object)dayTimestamp);
        return last6DayTimestamps.stream().map(time -> RedisKeyUtil.advertDailyStatKey((Long)query.getAppId(), (Long)query.getAdvertId(), (Long)query.getPackageId(), (Long)query.getMaterialId(), (Long)query.getTag(), (String)time)).collect(Collectors.toList());
    }

    @Override
    public Map<AdvertStatService.Query, StatisticData> get7DayStat(Collection<AdvertStatService.Query> queries) {
        try {
            DBTimeProfile.enter((String)"advertStatService.get7DayStat");
            LocalDate now = LocalDate.now();
            String nowTimestamp = now.format(DAY_FORMATTER);
            Map query2KeyMap = ListToMapTools.toMap(queries, Function.identity(), query -> RedisKeyUtil.advertDailyStatKey((Long)query.getAppId(), (Long)query.getAdvertId(), (Long)query.getPackageId(), (Long)query.getMaterialId(), (Long)query.getTag(), (String)nowTimestamp));
            Map<AdvertStatService.Query, StatisticData> last6DayStatMap = this.associateAdvert6DayStat(queries);
            ImmutableMap currentDayStatMap = this.currentDayStatCache.getAll(query2KeyMap.values());
            HashMap<AdvertStatService.Query, StatisticData> record = new HashMap<AdvertStatService.Query, StatisticData>(queries.size());
            for (AdvertStatService.Query query2 : queries) {
                StatisticData last6DayStat = last6DayStatMap.get(query2);
                StatisticData currentDayStat = (StatisticData)currentDayStatMap.get(query2KeyMap.get(query2));
                StatisticData statDo = this.associateAdvert7DayStat(last6DayStat, currentDayStat);
                record.put(query2, statDo);
            }
            HashMap<AdvertStatService.Query, StatisticData> hashMap = record;
            return hashMap;
        }
        catch (Exception e) {
            throw new RecommendEngineException("get7DayStat error", e);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    @Override
    public Map<AdvertStatService.Query, StatisticData> getCurrentDayStat(Collection<AdvertStatService.Query> queries) {
        try {
            DBTimeProfile.enter((String)"advertStatService.getCurrentDayStat");
            LocalDateTime now = LocalDateTime.now();
            String dayTimestamp = now.format(DAY_FORMATTER);
            HashMap<AdvertStatService.Query, String> query2KeyMap = new HashMap<AdvertStatService.Query, String>(queries.size());
            for (AdvertStatService.Query query : queries) {
                if (query == null) continue;
                String key = RedisKeyUtil.advertDailyStatKey((Long)query.getAppId(), (Long)query.getAdvertId(), (Long)query.getPackageId(), (Long)query.getMaterialId(), (Long)query.getTag(), (String)dayTimestamp);
                query2KeyMap.put(query, key);
            }
            ImmutableMap currentDayStatMap = this.currentDayStatCache.getAll(query2KeyMap.values());
            Map map = MapUtils.translate(query2KeyMap, (Map)currentDayStatMap);
            return map;
        }
        catch (Exception e) {
            throw new RecommendEngineException("get current day stat error", e);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    @Override
    public Map<AdvertStatService.Query, StatisticData> getCurrentHourStat(Collection<AdvertStatService.Query> queries) {
        try {
            DBTimeProfile.enter((String)"advertStatService.getCurrentHourStat");
            String hourTimestamp = LocalDateTime.now().format(HOUR_FORMATTER);
            HashMap<AdvertStatService.Query, String> query2KeyMap = new HashMap<AdvertStatService.Query, String>(queries.size());
            for (AdvertStatService.Query query : queries) {
                if (query == null) continue;
                String key = RedisKeyUtil.advertHourlyStatKey((Long)query.getAppId(), (Long)query.getAdvertId(), (Long)query.getPackageId(), (Long)query.getMaterialId(), (String)hourTimestamp);
                query2KeyMap.put(query, key);
            }
            ImmutableMap currentHourStatMap = this.currentHourStatCache.getAll(query2KeyMap.values());
            Map map = MapUtils.translate(query2KeyMap, (Map)currentHourStatMap);
            return map;
        }
        catch (Exception e) {
            throw new RecommendEngineException("get current hour stat error", e);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    @Override
    public Map<AdvertStatService.Query, List<StatisticData>> getTodayHourlyStat(Collection<AdvertStatService.Query> queries) {
        try {
            LocalDateTime now = LocalDateTime.now();
            int hour = now.getHour();
            HashMap query2KeyListMap = new HashMap(queries.size());
            ArrayList keyToLoad = new ArrayList(queries.size() * hour);
            List timestamps = ((List)this.hourlyTimestampCache.get((Object)now.format(DAY_FORMATTER))).subList(0, hour);
            for (AdvertStatService.Query query : queries) {
                Long appId = query.getAppId();
                Long advertId = query.getAdvertId();
                Long packageId = query.getPackageId();
                Long materialId = query.getMaterialId();
                List hourlyStatKey = timestamps.stream().map(timestamp -> RedisKeyUtil.advertHourlyStatKey((Long)appId, (Long)advertId, (Long)packageId, (Long)materialId, (String)timestamp)).collect(Collectors.toList());
                keyToLoad.addAll(hourlyStatKey);
                query2KeyListMap.put(query, hourlyStatKey);
            }
            ImmutableMap hourlyStatMap = this.hourlyStatCache.getAll(keyToLoad);
            HashMap<AdvertStatService.Query, List<StatisticData>> todayHourlyStatMap = new HashMap<AdvertStatService.Query, List<StatisticData>>(queries.size());
            for (AdvertStatService.Query query : queries) {
                List keys = (List)query2KeyListMap.get(query);
                todayHourlyStatMap.put(query, keys.stream().map(arg_0 -> ((ImmutableMap)hourlyStatMap).get(arg_0)).collect(Collectors.toList()));
            }
            return todayHourlyStatMap;
        }
        catch (Exception e) {
            throw new RecommendEngineException("get today hourly stat error", e);
        }
    }

    @Override
    public Map<String, CacheService.CacheInfo> getCacheInfo() {
        HashMap<String, CacheService.CacheInfo> map = new HashMap<String, CacheService.CacheInfo>();
        map.put("hourlyStatCache", CacheService.CacheInfo.generate(this.hourlyStatCache));
        map.put("currentHourStatCache", CacheService.CacheInfo.generate(this.currentHourStatCache));
        map.put("currentDayStatCache", CacheService.CacheInfo.generate(this.currentDayStatCache));
        map.put("dailyStatCache", CacheService.CacheInfo.generate(this.dailyStatCache));
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<AdvertStatService.Query, StatisticData> associateAdvert6DayStat(Collection<AdvertStatService.Query> queries) throws ExecutionException {
        try {
            DBTimeProfile.enter((String)"associateAdvert6DayStat");
            String dayTimestamp = LocalDateTime.now().format(DAY_FORMATTER);
            Map queryMap = ListToMapTools.toMap(queries, Function.identity(), query -> AdvertStatService.Query.newBuilder().advertId(query.getAdvertId()).appId(query.getAppId()).packageId(query.getPackageId()).tag(query.getTag()).materialId(query.getMaterialId()).timestamp(dayTimestamp).build());
            ImmutableMap all = this.daily6StatCache.getAll(queryMap.values());
            Map map = MapUtils.translate((Map)queryMap, (Map)all);
            return map;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private StatisticData sum(List<StatisticData> advertStatDoList) {
        long sumLaunch = 0L;
        long sumClick = 0L;
        long sumAction = 0L;
        long sumExposure = 0L;
        long sumFee = 0L;
        for (StatisticData advertStatDo : advertStatDoList) {
            sumLaunch += advertStatDo.getLaunchCount().longValue();
            sumClick += advertStatDo.getChargeClickCount().longValue();
            sumAction += advertStatDo.getConvertCount().longValue();
            sumExposure += advertStatDo.getExposureCount().longValue();
            sumFee += advertStatDo.getTotalConsume().longValue();
        }
        double ctr = 0.0;
        if (sumLaunch != 0L) {
            ctr = (double)sumClick / (double)sumLaunch;
        }
        double cvr = 0.0;
        if (sumClick != 0L) {
            cvr = (double)sumAction / (double)sumClick;
        }
        StatisticData advertStatDo = new StatisticData();
        advertStatDo.setCtr(ctr);
        advertStatDo.setCvr(cvr);
        advertStatDo.setLaunchCount(sumLaunch);
        advertStatDo.setChargeClickCount(sumClick);
        advertStatDo.setConvertCount(sumAction);
        advertStatDo.setExposureCount(sumExposure);
        advertStatDo.setTotalConsume(sumFee);
        return advertStatDo;
    }

    private StatisticData associateAdvert7DayStat(StatisticData last6DayStat, StatisticData currentDayStat) {
        return this.sum(Lists.newArrayList((Object[])new StatisticData[]{last6DayStat, currentDayStat}));
    }
}

