/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert.ctr.impl;

import cn.com.duiba.nezha.alg.alg.vo.BiddingRateDo;
import cn.com.duiba.nezha.engine.api.support.RecommendEngineException;
import cn.com.duiba.nezha.engine.biz.domain.advert.OrientationPackage;
import cn.com.duiba.nezha.engine.biz.service.CacheService;
import cn.com.duiba.nezha.engine.biz.service.advert.ctr.NewAdvertSupportService;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.stereotype.Service;

@Service
public class NewAdvertSupportServiceImpl
extends CacheService
implements NewAdvertSupportService {
    private LoadingCache<NewAdvertSupportService.BiddingKey, NewAdvertSupportService.Stat> newAdvertStatecache = CacheBuilder.newBuilder().expireAfterWrite(12L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<NewAdvertSupportService.BiddingKey, NewAdvertSupportService.Stat>(){

        public NewAdvertSupportService.Stat load(NewAdvertSupportService.BiddingKey key) throws Exception {
            NewAdvertSupportService.Stat stat1 = new NewAdvertSupportService.Stat();
            stat1.setInComing(new AtomicLong(0L));
            stat1.setOutGoing(new AtomicLong(0L));
            return stat1;
        }
    });

    @Override
    public void insertOutGoing(OrientationPackage orientationPackage, Long slotId) {
        try {
            DBTimeProfile.enter((String)"insertOutGoing");
            NewAdvertSupportService.BiddingKey advertKey = new NewAdvertSupportService.BiddingKey();
            advertKey.setAdvertId(orientationPackage.getAdvertId());
            advertKey.setSlotId(slotId);
            this.insertNewAdvertStatecache(advertKey);
            NewAdvertSupportService.BiddingKey advertAndOrientationKey = new NewAdvertSupportService.BiddingKey();
            advertAndOrientationKey.setAdvertId(orientationPackage.getAdvertId());
            advertAndOrientationKey.setSlotId(slotId);
            advertAndOrientationKey.setOrientationId(orientationPackage.getId());
            this.insertNewAdvertStatecache(advertAndOrientationKey);
            NewAdvertSupportService.BiddingKey tradeAndSlotKey = new NewAdvertSupportService.BiddingKey();
            tradeAndSlotKey.setNewTradeTagNum(orientationPackage.getNewTradeTagNum());
            tradeAndSlotKey.setSlotId(slotId);
            this.insertNewAdvertStatecache(tradeAndSlotKey);
            NewAdvertSupportService.BiddingKey slotKey = new NewAdvertSupportService.BiddingKey();
            slotKey.setSlotId(slotId);
            this.insertNewAdvertStatecache(slotKey);
        }
        catch (Exception e) {
            this.logger.error("newAdvertStateCache error :{}", (Throwable)e);
            throw new RecommendEngineException("get newAdvertStateCache error", e);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    @Override
    public void incrBidingCount(NewAdvertSupportService.BiddingKey advertKey, long size) {
        try {
            NewAdvertSupportService.Stat stat = (NewAdvertSupportService.Stat)this.newAdvertStatecache.get((Object)advertKey);
            stat.getInComing().getAndAdd(size);
        }
        catch (Exception e) {
            this.logger.error("incrBidingCount error :{}", (Throwable)e);
            throw new RecommendEngineException("incrBidingCount error", e);
        }
    }

    @Override
    public BiddingRateDo getBiddingRate(NewAdvertSupportService.BiddingKey advertKey) {
        try {
            NewAdvertSupportService.Stat stat = (NewAdvertSupportService.Stat)this.newAdvertStatecache.get((Object)advertKey);
            long inComing = stat.getInComing().get();
            double advertRate = inComing == 0L ? 0.0 : stat.getOutGoing().doubleValue() / (double)inComing;
            return new BiddingRateDo(Long.valueOf(stat.getOutGoing().longValue()), Long.valueOf(inComing), Double.valueOf(advertRate));
        }
        catch (Exception e) {
            this.logger.error("getBiddingRate error :{}", (Throwable)e);
            throw new RecommendEngineException("get getBiddingRate error", e);
        }
    }

    public void insertNewAdvertStatecache(NewAdvertSupportService.BiddingKey advertKey) {
        try {
            NewAdvertSupportService.Stat stat = (NewAdvertSupportService.Stat)this.newAdvertStatecache.get((Object)advertKey);
            stat.getOutGoing().getAndAdd(1L);
        }
        catch (Exception e) {
            this.logger.error("insertNewAdvertStatecache error :{}", (Throwable)e);
            throw new RecommendEngineException("insertNewAdvertStatecache error", e);
        }
    }

    @Override
    public Map<NewAdvertSupportService.BiddingKey, NewAdvertSupportService.Stat> getCacheInfo() {
        return this.newAdvertStatecache.asMap();
    }
}

