/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert.ctr.impl;

import cn.com.duiba.nezha.engine.biz.domain.advert.Advert;
import cn.com.duiba.nezha.engine.biz.entity.nezha.advert.AdvertStatisticMergeEntity;
import cn.com.duiba.nezha.engine.biz.entity.nezha.advert.TagCvrData;
import cn.com.duiba.nezha.engine.biz.service.CacheService;
import cn.com.duiba.nezha.engine.biz.service.advert.ctr.TagStatAssociationService;
import cn.com.duiba.nezha.engine.common.utils.ListToMapTools;
import cn.com.duiba.nezha.engine.common.utils.RedisKeyUtil;
import cn.com.duiba.nezha.engine.common.utils.StringRedisHelper;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class TagStatAssociationServiceImpl
extends CacheService
implements TagStatAssociationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TagStatAssociationServiceImpl.class);
    private static final CacheService.CacheDuration DAILY_STAT_CACHE_DURATION = new CacheService.CacheDuration(7L, TimeUnit.DAYS);
    private static final CacheService.CacheDuration CURRENT_DAY_STAT_CACHE_DURATION = new CacheService.CacheDuration(5L, TimeUnit.MINUTES);
    private static final CacheService.CacheDuration CURRENT_HOUR_STAT_CACHE_DURATION = new CacheService.CacheDuration(2L, TimeUnit.MINUTES);
    private LoadingCache<String, TagCvrData> dailyStatCache = CacheBuilder.newBuilder().expireAfterWrite(DAILY_STAT_CACHE_DURATION.getDuration().longValue(), DAILY_STAT_CACHE_DURATION.getTimeUnit()).recordStats().build((CacheLoader)new CacheLoader<String, TagCvrData>(){

        public TagCvrData load(String key) throws Exception {
            throw new IllegalAccessException("not suppose single query");
        }

        public Map<String, TagCvrData> loadAll(Iterable<? extends String> keys) throws Exception {
            return StringRedisHelper.of((StringRedisTemplate)TagStatAssociationServiceImpl.this.nezhaStringRedisTemplate).valueMultiGet(keys, TagCvrData.class, TagCvrData::new);
        }
    });
    private LoadingCache<String, TagCvrData> currentDayStatCache = CacheBuilder.newBuilder().expireAfterWrite(CURRENT_DAY_STAT_CACHE_DURATION.getDuration().longValue(), CURRENT_DAY_STAT_CACHE_DURATION.getTimeUnit()).recordStats().build((CacheLoader)new CacheLoader<String, TagCvrData>(){

        public TagCvrData load(String key) throws Exception {
            throw new IllegalAccessException("not suppose single query");
        }

        public Map<String, TagCvrData> loadAll(Iterable<? extends String> keys) throws Exception {
            return StringRedisHelper.of((StringRedisTemplate)TagStatAssociationServiceImpl.this.nezhaStringRedisTemplate).valueMultiGet(keys, TagCvrData.class, TagCvrData::new);
        }
    });
    private LoadingCache<String, TagCvrData> currentHourStatCache = CacheBuilder.newBuilder().expireAfterWrite(CURRENT_HOUR_STAT_CACHE_DURATION.getDuration().longValue(), CURRENT_HOUR_STAT_CACHE_DURATION.getTimeUnit()).recordStats().build((CacheLoader)new CacheLoader<String, TagCvrData>(){

        public TagCvrData load(String key) throws Exception {
            throw new IllegalAccessException("not suppose single query");
        }

        public Map<String, TagCvrData> loadAll(Iterable<? extends String> keys) throws Exception {
            return StringRedisHelper.of((StringRedisTemplate)TagStatAssociationServiceImpl.this.nezhaStringRedisTemplate).valueMultiGet(keys, TagCvrData.class, TagCvrData::new);
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleTagStat(Collection<Advert> adverts, Long appId) {
        try {
            DBTimeProfile.enter((String)"tagStatAssociationService.handleTagStat");
            List advertList = adverts.stream().filter(advert -> StringUtils.isNotBlank((CharSequence)advert.getMatchTags())).collect(Collectors.toList());
            Map advertMatchTags = ListToMapTools.toMap(advertList, Function.identity(), advert -> Stream.of(advert.getMatchTags().split(",")).collect(Collectors.toSet()));
            Set tagIds = advertMatchTags.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            HashMap<String, String> appTag2ChKeyMap = new HashMap<String, String>(tagIds.size());
            HashMap<String, String> globalTag2ChKeyMap = new HashMap<String, String>(tagIds.size());
            HashMap<String, String> appTag2CdKeyMap = new HashMap<String, String>(tagIds.size());
            HashMap<String, String> globalTag2CdKeyMap = new HashMap<String, String>(tagIds.size());
            HashMap appTag2Last6DayKeyMap = new HashMap(tagIds.size());
            HashMap globalTag2Last6DayKeyMap = new HashMap(tagIds.size());
            String nowHour = LocalDateTime.now().format(HOUR_FORMATTER);
            String nowDay = LocalDate.now().format(DAY_FORMATTER);
            for (String tagId : tagIds) {
                appTag2ChKeyMap.put(tagId, RedisKeyUtil.tagHourlyStatKey((Long)appId, (String)tagId, (String)nowHour));
                globalTag2ChKeyMap.put(tagId, RedisKeyUtil.tagHourlyStatKey(null, (String)tagId, (String)nowHour));
                appTag2CdKeyMap.put(tagId, RedisKeyUtil.tagDailyStatKey((Long)appId, (String)tagId, (String)nowDay));
                globalTag2CdKeyMap.put(tagId, RedisKeyUtil.tagDailyStatKey(null, (String)tagId, (String)nowDay));
                List last6DayTimestamps = (List)this.last6DayTimestampCache.get((Object)nowDay);
                appTag2Last6DayKeyMap.put(tagId, last6DayTimestamps.stream().map(time -> RedisKeyUtil.tagDailyStatKey((Long)appId, (String)tagId, (String)time)).collect(Collectors.toList()));
                globalTag2Last6DayKeyMap.put(tagId, last6DayTimestamps.stream().map(time -> RedisKeyUtil.tagDailyStatKey(null, (String)tagId, (String)time)).collect(Collectors.toList()));
            }
            HashSet currentHourlyKeys = new HashSet(tagIds.size() * 2);
            currentHourlyKeys.addAll(appTag2ChKeyMap.values());
            currentHourlyKeys.addAll(globalTag2ChKeyMap.values());
            ImmutableMap currentHourStat = this.currentHourStatCache.getAll(currentHourlyKeys);
            HashSet currentDayKeys = new HashSet(tagIds.size() * 2);
            currentDayKeys.addAll(appTag2CdKeyMap.values());
            currentDayKeys.addAll(globalTag2CdKeyMap.values());
            ImmutableMap currentDayStat = this.currentDayStatCache.getAll(currentDayKeys);
            HashSet dailyKeys = new HashSet(tagIds.size() * 12);
            dailyKeys.addAll(appTag2Last6DayKeyMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
            dailyKeys.addAll(globalTag2Last6DayKeyMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
            ImmutableMap dailyStat = this.dailyStatCache.getAll(dailyKeys);
            adverts.forEach(advert -> {
                Set tags = advertMatchTags.getOrDefault(advert, new HashSet());
                advert.getOrientationPackages().forEach(orientationPackage -> {
                    Integer cvrType = orientationPackage.getCvrType();
                    List entities = tags.stream().map(tagId -> {
                        Double appCh = ((TagCvrData)currentHourStat.get(appTag2ChKeyMap.get(tagId))).getCvr(cvrType);
                        Double appCd = ((TagCvrData)currentDayStat.get(appTag2CdKeyMap.get(tagId))).getCvr(cvrType);
                        Double app7d = Stream.concat(((List)appTag2Last6DayKeyMap.get(tagId)).stream().map(arg_0 -> ((ImmutableMap)dailyStat).get(arg_0)).map(x -> x.getCvr(cvrType)), Lists.newArrayList((Object[])new Double[]{appCd}).stream()).filter(Objects::nonNull).mapToDouble(x -> x).filter(value -> value > 0.0).average().orElse(0.0);
                        Double globalCh = ((TagCvrData)currentHourStat.get(globalTag2ChKeyMap.get(tagId))).getCvr(cvrType);
                        Double globalCd = ((TagCvrData)currentDayStat.get(globalTag2CdKeyMap.get(tagId))).getCvr(cvrType);
                        Double global7D = Stream.concat(((List)globalTag2Last6DayKeyMap.get(tagId)).stream().map(arg_0 -> ((ImmutableMap)dailyStat).get(arg_0)).map(x -> x.getCvr(cvrType)), Lists.newArrayList((Object[])new Double[]{globalCd}).stream()).filter(value -> value > 0.0).mapToDouble(x -> x).average().orElse(0.0);
                        return new AdvertStatisticMergeEntity.Builder().appCurrentlyHour(appCh).appCurrentlyDay(appCd).appRecently7Day(app7d).globalCurrentlyHour(globalCh).globalCurrentlyDay(globalCd).globalRecently7Day(global7D).build();
                    }).collect(Collectors.toList());
                    double appCh = entities.stream().map(AdvertStatisticMergeEntity::getAppCurrentlyHour).filter(Objects::nonNull).mapToDouble(Double::doubleValue).average().orElse(0.0);
                    double appCd = entities.stream().map(AdvertStatisticMergeEntity::getAppCurrentlyDay).filter(Objects::nonNull).mapToDouble(Double::doubleValue).average().orElse(0.0);
                    double app7d = entities.stream().map(AdvertStatisticMergeEntity::getAppRecently7Day).filter(Objects::nonNull).mapToDouble(Double::doubleValue).average().orElse(0.0);
                    double globalCh = entities.stream().map(AdvertStatisticMergeEntity::getGlobalCurrentlyHour).filter(Objects::nonNull).mapToDouble(Double::doubleValue).average().orElse(0.0);
                    double globalCd = entities.stream().map(AdvertStatisticMergeEntity::getGlobalCurrentlyDay).filter(Objects::nonNull).mapToDouble(Double::doubleValue).average().orElse(0.0);
                    double global7D = entities.stream().map(AdvertStatisticMergeEntity::getGlobalRecently7Day).filter(Objects::nonNull).mapToDouble(Double::doubleValue).average().orElse(0.0);
                    orientationPackage.setTagStatisticData(new AdvertStatisticMergeEntity.Builder().appCurrentlyHour(appCh).appCurrentlyDay(appCd).appRecently7Day(app7d).globalCurrentlyHour(globalCh).globalCurrentlyDay(globalCd).globalRecently7Day(global7D).build());
                });
            });
        }
        catch (Exception e) {
            LOGGER.error("get tag stat error:{}", (Throwable)e);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    @Override
    public Map<String, CacheService.CacheInfo> getCacheInfo() {
        HashMap<String, CacheService.CacheInfo> map = new HashMap<String, CacheService.CacheInfo>();
        map.put("dailyStatCache", CacheService.CacheInfo.generate(this.dailyStatCache));
        map.put("currentHourStatCache", CacheService.CacheInfo.generate(this.currentHourStatCache));
        map.put("currentDayStatCache", CacheService.CacheInfo.generate(this.currentDayStatCache));
        return map;
    }
}

