/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert.engine.impl;

import cn.com.duiba.nezha.engine.api.support.RecommendEngineException;
import cn.com.duiba.nezha.engine.biz.service.CacheService;
import cn.com.duiba.nezha.engine.biz.service.advert.engine.EncourageArpuOneService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class EncourageArpuOneServiceImpl
extends CacheService
implements EncourageArpuOneService {
    private static final Double DEFAULT_ARUP = -1.0;
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    private LoadingCache<String, Double> encourageCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Double>(){

        public Double load(String key) throws Exception {
            String arup = (String)EncourageArpuOneServiceImpl.this.stringRedisTemplate.opsForValue().get((Object)key);
            if (StringUtils.isEmpty((String)arup)) {
                return DEFAULT_ARUP;
            }
            return Double.valueOf(arup);
        }
    });

    @Override
    public void insertArpu(String orderId, Double arpu) {
        if (arpu == null) {
            arpu = DEFAULT_ARUP;
        }
        this.stringRedisTemplate.opsForValue().set((Object)orderId, (Object)String.valueOf(arpu), 3L, TimeUnit.MINUTES);
    }

    @Override
    public Double getArpuByOrderId(String orderId) {
        try {
            if (StringUtils.isEmpty((String)orderId)) {
                return null;
            }
            return (Double)this.encourageCache.get((Object)orderId);
        }
        catch (Exception e) {
            this.logger.error("EncourageArpuOneServiceImpl.getArpuByOrderId error :{}", (Throwable)e);
            throw new RecommendEngineException("get getArpuByOrderId error", e);
        }
    }
}

