/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert.feature.impl;

import cn.com.duiba.nezha.engine.biz.service.advert.feature.AdvertConversionDataService;
import cn.com.duiba.nezha.engine.biz.service.advert.feature.HbaseDataService;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdvertConversionDataServiceImpl
implements AdvertConversionDataService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertConversionDataServiceImpl.class);
    private static final String TABLE_NAME = "dws_cpc_back_stat_di";
    @Autowired
    private HbaseDataService hbaseDataService;

    @Override
    public Map<String, Map<String, Long>> getAdvertConverionDataByKey(List<String> rowKeys) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)rowKeys.size());
        Map<String, Result> dataFromHbaseByRowKey = this.hbaseDataService.getDataFromHbaseByRowKey(rowKeys, TABLE_NAME);
        rowKeys.forEach(rowKey -> {
            Map<String, Long> valueMap = this.resolverResultValueToLong((Result)dataFromHbaseByRowKey.get(rowKey));
            resultMap.put(rowKey, valueMap);
        });
        return resultMap;
    }

    private Map<String, Long> resolverResultValueToLong(Result result) {
        if (result == null || result.isEmpty()) {
            return new HashMap<String, Long>();
        }
        List cells = result.listCells();
        HashMap<String, Long> resultMap = new HashMap<String, Long>(cells.size());
        for (Cell cell : cells) {
            String qualifier = new String(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
            Long value = Bytes.toLong((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
            resultMap.put(qualifier, value);
        }
        return resultMap;
    }
}

