/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert.feature.impl;

import cn.com.duiba.nezha.engine.biz.constant.GlobalConstant;
import cn.com.duiba.nezha.engine.biz.domain.AppInstallDo;
import cn.com.duiba.nezha.engine.biz.entity.nezha.advert.AppInstallFeature;
import cn.com.duiba.nezha.engine.biz.service.advert.feature.ConsumerAppInstallService;
import cn.com.duiba.nezha.engine.common.utils.ListToMapTools;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class ConsumerAppInstallServiceImpl
implements ConsumerAppInstallService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerAppInstallServiceImpl.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    private LoadingCache<String, AppInstallDo> cache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).build((CacheLoader)new CacheLoader<String, AppInstallDo>(){

        public AppInstallDo load(String key) {
            throw new UnsupportedOperationException("not support single query");
        }

        public Map<String, AppInstallDo> loadAll(Iterable<? extends String> keys) {
            DBTimeProfile.enter((String)"queryInstalledApp");
            List record = ConsumerAppInstallServiceImpl.this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"id").in((Collection)Lists.newArrayList(keys))), AppInstallDo.class, "pkg_cluster_cate5");
            DBTimeProfile.release();
            Map id2doMap = ListToMapTools.toMap((Collection)record, AppInstallDo::getId, Function.identity());
            return StreamSupport.stream(keys.spliterator(), false).collect(HashMap::new, (m, v) -> m.put(v, Optional.ofNullable(id2doMap.get(v)).orElse(new AppInstallDo())), HashMap::putAll);
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AppInstallFeature getFeature(List<String> appNames) {
        if (CollectionUtils.isEmpty(appNames)) {
            return AppInstallFeature.DEFAULT;
        }
        try {
            DBTimeProfile.enter((String)"ConsumerAppInstallService.getAppInstallFeature");
            ImmutableMap record = this.cache.getAll(appNames);
            ImmutableCollection datas = record.values();
            List<String> firstCategories = this.mapperToList((Collection<AppInstallDo>)datas, AppInstallDo::getCategory1_id);
            Map<String, Long> firstCategoryCount = this.count((Collection<AppInstallDo>)datas, AppInstallDo::getCategory1_id);
            List<String> secondCategories = this.mapperToList((Collection<AppInstallDo>)datas, AppInstallDo::getCategory2_id);
            Map<String, Long> secondCategoryCount = this.count((Collection<AppInstallDo>)datas, AppInstallDo::getCategory2_id);
            List<String> clusterIdList = this.mapperToList((Collection<AppInstallDo>)datas, AppInstallDo::getClass_id);
            List<String> importantAppList = datas.stream().filter(AppInstallDo::isImportant).map(AppInstallDo::getId).collect(Collectors.toList());
            boolean hasGame = datas.stream().anyMatch(AppInstallDo::isGame);
            AppInstallFeature appInstallFeature = new AppInstallFeature.Builder().firstCategory(firstCategories).secondCategory(secondCategories).clusterIdList(clusterIdList).importantAppList(importantAppList).firstCategoryCount(firstCategoryCount).secondCategoryCount(secondCategoryCount).hasGame(hasGame).build();
            return appInstallFeature;
        }
        catch (Exception e) {
            LOGGER.error("query app install feature error :{}", (Throwable)e);
            AppInstallFeature appInstallFeature = AppInstallFeature.DEFAULT;
            return appInstallFeature;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private List<String> mapperToList(Collection<AppInstallDo> datas, Function<AppInstallDo, String> mapper) {
        return datas.stream().map(mapper).filter(Objects::nonNull).flatMap(str -> GlobalConstant.SPLITTER.splitToList((CharSequence)str).stream()).distinct().collect(Collectors.toList());
    }

    private Map<String, Long> count(Collection<AppInstallDo> datas, Function<AppInstallDo, String> mapper) {
        return datas.stream().map(mapper).filter(Objects::nonNull).flatMap(str -> GlobalConstant.SPLITTER.splitToList((CharSequence)str).stream()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
    }
}

