/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert.feature.impl;

import cn.com.duiba.nezha.alg.feature.vo.FeatureDo;
import cn.com.duiba.nezha.engine.biz.domain.ConsumerFeatureDO;
import cn.com.duiba.nezha.engine.biz.service.advert.feature.ConsumerFeatureService;
import cn.com.duiba.nezha.engine.biz.support.StringTool;
import cn.com.duiba.nezha.engine.common.utils.HBaseResultCreater;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.hazelcast.util.MD5Util;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.hadoop.hbase.HbaseTemplate;
import org.springframework.stereotype.Service;

@Service
public class ConsumerFeatureServiceImpl
implements ConsumerFeatureService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerFeatureServiceImpl.class);
    private static final String TABLE_NAME = "tb_consumer_order_feature";
    private static final String TB_USER_FEATURE = "tb_user_feature";
    private static final byte[] FAMILY = "cf".getBytes();
    private static final String DATE_PATTERN = "yyyyMMdd";
    private static final String DATE_TIME_FORMAT = "yyyyMMddHHmmss";
    private static final String LAND = "0";
    private static final String START = "2";
    private static final String REGISTER = "3";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final Long DEFAULT_ORDER_COUNT = 0L;
    private static final Map<String, List<String>> staticQueries = ImmutableMap.of((Object)"cf", (Object)Lists.newArrayList((Object[])new String[]{"last_order_id", "last_order_time", "billing_order_id", "last_activity_id"}));
    @Autowired
    private HbaseTemplate hbaseTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ConsumerFeatureDO> getFeatures(List<String> rowKeys) {
        List keys = rowKeys.stream().distinct().collect(Collectors.toList());
        HashMap<String, ConsumerFeatureDO> record = new HashMap<String, ConsumerFeatureDO>(keys.size());
        try {
            DBTimeProfile.enter((String)"ConsumerFeatureService.getFeatures");
            Map map = (Map)this.hbaseTemplate.execute(TABLE_NAME, table -> {
                byte[] currentDayColumnName = LocalDate.now().format(DATE_TIME_FORMATTER).getBytes();
                byte[] yesterDayColumnName = LocalDate.now().minusDays(1L).format(DATE_TIME_FORMATTER).getBytes();
                byte[] beforeYesterDayColumnName = LocalDate.now().minusDays(2L).format(DATE_TIME_FORMATTER).getBytes();
                List gets = keys.stream().map(rowKey -> {
                    Get get = new Get(rowKey.getBytes());
                    for (Map.Entry<String, List<String>> entry : staticQueries.entrySet()) {
                        byte[] family = entry.getKey().getBytes();
                        List<String> qualifiers = entry.getValue();
                        for (String qualifier : qualifiers) {
                            get.addColumn(family, qualifier.getBytes());
                        }
                    }
                    get.addColumn(FAMILY, currentDayColumnName);
                    get.addColumn(FAMILY, yesterDayColumnName);
                    get.addColumn(FAMILY, beforeYesterDayColumnName);
                    return get;
                }).collect(Collectors.toList());
                DBTimeProfile.enter((String)"getFeaturesFromHBase");
                Result[] results = table.get(gets);
                DBTimeProfile.release();
                for (int i = 0; i < results.length; ++i) {
                    Result result = results[i];
                    String rowKey2 = (String)keys.get(i);
                    HBaseResultCreater.of((Result)result, ConsumerFeatureDO.class).build().ifPresent(feature -> {
                        Long currentDayOrderCount = Optional.ofNullable(this.getValue(result, FAMILY, currentDayColumnName)).orElse(DEFAULT_ORDER_COUNT);
                        feature.setCurrentDayOrderCount(currentDayOrderCount);
                        Long yesterDayOrderCount = Optional.ofNullable(this.getValue(result, FAMILY, yesterDayColumnName)).orElse(DEFAULT_ORDER_COUNT);
                        feature.setYesterDayOrderCount(yesterDayOrderCount);
                        Long beforeYesterDayOrderCount = Optional.ofNullable(this.getValue(result, FAMILY, beforeYesterDayColumnName)).orElse(DEFAULT_ORDER_COUNT);
                        feature.setBeforeYesterDayOrderCount(beforeYesterDayOrderCount);
                        record.put(rowKey2, (ConsumerFeatureDO)feature);
                    });
                }
                return record;
            });
            return map;
        }
        catch (Exception e) {
            LOGGER.error("query consumer feature error:{} ", (Throwable)e);
        }
        finally {
            DBTimeProfile.release();
        }
        return record;
    }

    @Override
    public void getUserBehaviorFeature(FeatureDo featureDo, Long consumerId) {
        String str = consumerId.toString();
        Map<String, String> userBehaviorDataMap = this.getUserBehaviorDataMap(str);
        this.dealUserBehaviorData(featureDo, userBehaviorDataMap);
    }

    private void dealUserBehaviorData(FeatureDo featureDo, Map<String, String> userBehaviorDataMap) {
        if (userBehaviorDataMap.isEmpty()) {
            return;
        }
        try {
            ArrayList clickAdvertValueList = Lists.newArrayList();
            ArrayList clickAccountValueList = Lists.newArrayList();
            ArrayList clickResourceValueList = Lists.newArrayList();
            ArrayList clickTradeValueList = Lists.newArrayList();
            Map<String, List<ColValue>> conversionAdvertValueMap = this.buildConversionMap();
            Map<String, List<ColValue>> conversionAccountValueMap = this.buildConversionMap();
            Map<String, List<ColValue>> conversionResourceValueMap = this.buildConversionMap();
            Map<String, List<ColValue>> conversionTradeValueMap = this.buildConversionMap();
            for (Map.Entry<String, String> entry : userBehaviorDataMap.entrySet()) {
                String entryKey = entry.getKey();
                String entryValue = entry.getValue();
                List<String> keySplit = StringTool.getStringListByStr(entryKey, "_");
                if (CollectionUtils.isEmpty(keySplit)) continue;
                String timesStr = keySplit.get(2);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_TIME_FORMAT);
                Long times = simpleDateFormat.parse(timesStr).getTime();
                ColValue colValue = new ColValue(times, entryValue);
                switch (entryKey.substring(0, 5)) {
                    case "cl_ad": {
                        clickAdvertValueList.add(colValue);
                        break;
                    }
                    case "cl_ac": {
                        clickAccountValueList.add(colValue);
                        break;
                    }
                    case "cl_re": {
                        clickResourceValueList.add(colValue);
                        break;
                    }
                    case "cl_tr": {
                        clickTradeValueList.add(colValue);
                        break;
                    }
                    case "e0_ad": {
                        conversionAdvertValueMap.get(LAND).add(colValue);
                        break;
                    }
                    case "e2_ad": {
                        conversionAdvertValueMap.get(START).add(colValue);
                        break;
                    }
                    case "e3_ad": {
                        conversionAdvertValueMap.get(REGISTER).add(colValue);
                        break;
                    }
                    case "e0_ac": {
                        conversionAccountValueMap.get(LAND).add(colValue);
                        break;
                    }
                    case "e2_ac": {
                        conversionAccountValueMap.get(START).add(colValue);
                        break;
                    }
                    case "e3_ac": {
                        conversionAccountValueMap.get(REGISTER).add(colValue);
                        break;
                    }
                    case "e0_re": {
                        conversionResourceValueMap.get(LAND).add(colValue);
                        break;
                    }
                    case "e2_re": {
                        conversionResourceValueMap.get(START).add(colValue);
                        break;
                    }
                    case "e3_re": {
                        conversionResourceValueMap.get(REGISTER).add(colValue);
                        break;
                    }
                    case "e0_tr": {
                        conversionTradeValueMap.get(LAND).add(colValue);
                        break;
                    }
                    case "e2_tr": {
                        conversionTradeValueMap.get(START).add(colValue);
                        break;
                    }
                    case "e3_tr": {
                        conversionTradeValueMap.get(REGISTER).add(colValue);
                        break;
                    }
                }
            }
            String clickAdvertValue = this.sortByTimesTopTwenty(clickAdvertValueList);
            String clickAccountValue = this.sortByTimesTopTwenty(clickAccountValueList);
            String clickResourceValue = this.sortByTimesTopTwenty(clickResourceValueList);
            String clickTradeValue = this.sortByTimesTopTwenty(clickTradeValueList);
            Map<String, String> conversionAdvertValue = this.unrepeatSortMap(conversionAdvertValueMap);
            Map<String, String> conversionAccountValue = this.unrepeatSortMap(conversionAccountValueMap);
            Map<String, String> conversiuonResourceValue = this.unrepeatSortMap(conversionResourceValueMap);
            Map<String, String> conversionTradeValue = this.unrepeatSortMap(conversionTradeValueMap);
            featureDo.setClickAdIds(clickAdvertValue);
            featureDo.setClickAcIds(clickAccountValue);
            featureDo.setClickReIds(clickResourceValue);
            featureDo.setClickTrIds(clickTradeValue);
            featureDo.setConvAdIds(conversionAdvertValue);
            featureDo.setConvAcIds(conversionAccountValue);
            featureDo.setConvReIds(conversiuonResourceValue);
            featureDo.setConvTrIds(conversionTradeValue);
        }
        catch (Exception e) {
            LOGGER.error("ConsumerFeatureServiceImpl.dealData error:{}", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getUserBehaviorDataMap(String str) {
        String rowkey = MD5Util.toMD5String((String)str).substring(0, 4) + "-" + str;
        HashMap resultMap = Maps.newHashMap();
        DBTimeProfile.enter((String)"hbaseUserBehaviorGet");
        try {
            this.hbaseTemplate.execute(TB_USER_FEATURE, table -> {
                Get get = new Get(rowkey.getBytes());
                Result result = table.get(get);
                List cells = result.listCells();
                if (CollectionUtils.isEmpty((Collection)cells)) {
                    return null;
                }
                for (Cell cell : cells) {
                    String qualifier = new String(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
                    String value = new String(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
                    resultMap.put(qualifier, value);
                }
                return null;
            });
            HashMap hashMap = resultMap;
            return hashMap;
        }
        catch (Exception e) {
            LOGGER.error("ConsumerFeatureServiceImpl.getUserBehaviorFeature error:{}", (Throwable)e);
            HashMap hashMap = resultMap;
            return hashMap;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private Map<String, List<ColValue>> buildConversionMap() {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)3);
        resultMap.put(LAND, Lists.newArrayList());
        resultMap.put(START, Lists.newArrayList());
        resultMap.put(REGISTER, Lists.newArrayList());
        return resultMap;
    }

    private String unrepeatSortByTimesTopTwenty(List<ColValue> list) {
        if (CollectionUtils.isEmpty(list)) {
            return "";
        }
        List<String> resultList = (list = list.stream().sorted(Comparator.comparing(ColValue::getTimes).reversed()).collect(Collectors.toList())).stream().map(ColValue::getValue).distinct().collect(Collectors.toList());
        if (resultList.size() > 20) {
            resultList = resultList.subList(0, 20);
        }
        return StringTool.getStringByList(resultList, ",");
    }

    private Map<String, String> unrepeatSortMap(Map<String, List<ColValue>> conversionMap) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)conversionMap.size());
        conversionMap.forEach((key, value) -> {
            String resultValue = this.unrepeatSortByTimesTopTwenty((List<ColValue>)value);
            resultMap.put(key, resultValue);
        });
        return resultMap;
    }

    private String sortByTimesTopTwenty(List<ColValue> list) {
        if (CollectionUtils.isEmpty(list)) {
            return "";
        }
        List<String> resultList = (list = list.stream().sorted(Comparator.comparing(ColValue::getTimes).reversed()).collect(Collectors.toList())).stream().map(ColValue::getValue).collect(Collectors.toList());
        if (resultList.size() > 20) {
            resultList = resultList.subList(0, 20);
        }
        return StringTool.getStringByList(resultList, ",");
    }

    private Long getValue(Result result, byte[] family, byte[] column) {
        if (result == null) {
            return null;
        }
        byte[] value = result.getValue(family, column);
        if (value == null || value.length == 0) {
            return null;
        }
        return Long.valueOf(Bytes.toString((byte[])value));
    }

    class ColValue {
        private Long times;
        private String value;

        public ColValue(Long times, String value) {
            this.times = times;
            this.value = value;
        }

        public Long getTimes() {
            return this.times;
        }

        public void setTimes(Long times) {
            this.times = times;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

