/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert.feature.impl;

import cn.com.duiba.nezha.alg.feature.vo.FeatureDo;
import cn.com.duiba.nezha.engine.biz.service.advert.feature.ResourceFeatureService;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.hadoop.hbase.HbaseTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

@Service
public class ResourceFeatureServiceImpl
implements ResourceFeatureService {
    private static final Logger logger = LoggerFactory.getLogger(ResourceFeatureServiceImpl.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final String TABLE_NAME = "consumer_resource_feature";
    private static final byte[] FAMILY = "cf".getBytes();
    @Autowired
    private HbaseTemplate hbaseTemplate;

    private String dayKey(Long consumerId) {
        String k = consumerId + "_" + LocalDate.now().format(DATE_TIME_FORMATTER);
        return this.key(k) + "-" + k;
    }

    private String key(String k) {
        return DigestUtils.md5DigestAsHex((byte[])k.getBytes()).substring(0, 4);
    }

    @Override
    public void get(Long consumerId, FeatureDo featureDo) {
        HashMap dayResourceOrderRank = new HashMap();
        HashMap dayResourceChargeCnt = new HashMap();
        HashMap dayResourceConvertCnt = new HashMap();
        HashMap resourceLastGmtCreateTime = new HashMap();
        HashMap resourceLastLaunchOrderId = new HashMap();
        HashMap resourceLastClickOrderId = new HashMap();
        HashMap resourceLastConvertOrderId = new HashMap();
        String dayKey = this.dayKey(consumerId);
        ArrayList keys = Lists.newArrayList((Object[])new String[]{dayKey});
        this.hbaseTemplate.execute(TABLE_NAME, table -> {
            List gets = keys.stream().map(key -> new Get(key.getBytes()).addFamily(FAMILY)).collect(Collectors.toList());
            DBTimeProfile.enter((String)"hbaseResourceGet");
            Result[] results = table.get(gets);
            DBTimeProfile.release();
            for (int i = 0; i < keys.size(); ++i) {
                Cell[] cells;
                Result result = results[i];
                for (Cell cell : cells = result.rawCells()) {
                    String column = Bytes.toString((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength());
                    String value = new String(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
                    if (column.contains("770201")) {
                        resourceLastGmtCreateTime.put(column, value);
                    }
                    if (column.contains("770301_1")) {
                        resourceLastLaunchOrderId.put(column, value);
                    }
                    if (column.contains("770301_2")) {
                        resourceLastClickOrderId.put(column, value);
                    }
                    if (column.contains("770301_3")) {
                        resourceLastConvertOrderId.put(column, value);
                    }
                    if (column.contains("770501")) {
                        featureDo.setLastOperatingResource(value);
                    }
                    if (column.contains("770101")) {
                        dayResourceOrderRank.put(column, Long.parseLong(value));
                    }
                    if (column.contains("770401")) {
                        dayResourceChargeCnt.put(column, Long.parseLong(value));
                    }
                    if (!column.contains("770402")) continue;
                    dayResourceConvertCnt.put(column, Long.parseLong(value));
                }
            }
            featureDo.setDayResourceOrderRank(dayResourceOrderRank);
            featureDo.setDayResourceChargeCnt(dayResourceChargeCnt);
            featureDo.setDayResourceConvertCnt(dayResourceConvertCnt);
            featureDo.setResourceLastGmtCreateTime(resourceLastGmtCreateTime);
            featureDo.setResourceLastLaunchOrderId(resourceLastLaunchOrderId);
            featureDo.setResourceLastClickOrderId(resourceLastClickOrderId);
            featureDo.setResourceLastConvertOrderId(resourceLastConvertOrderId);
            return null;
        });
    }
}

