/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert.floorprice;

import cn.com.duiba.nezha.alg.alg.basepricecontrol.BasePriceControl;
import cn.com.duiba.nezha.alg.alg.basepricecontrol.BasePriceInfo;
import cn.com.duiba.nezha.alg.alg.basepricecontrol.BasePriceParams;
import cn.com.duiba.nezha.alg.alg.basepricecontrol.BasePriceResult;
import cn.com.duiba.nezha.engine.api.support.RecommendEngineException;
import cn.com.duiba.nezha.engine.biz.domain.AppDo;
import cn.com.duiba.nezha.engine.biz.domain.FloorPriceFeatureIndex;
import cn.com.duiba.nezha.engine.biz.domain.FloorPriceStatisticData;
import cn.com.duiba.nezha.engine.biz.domain.advert.OrientationPackage;
import cn.com.duiba.nezha.engine.biz.service.CacheService;
import cn.com.duiba.nezha.engine.common.utils.ListToMapTools;
import cn.com.duiba.nezha.engine.common.utils.MapUtils;
import cn.com.duiba.nezha.engine.common.utils.RedisKeyUtil;
import cn.com.duiba.nezha.engine.common.utils.StringRedisHelper;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.alibaba.fastjson.JSON;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class FloorPriceService
extends CacheService {
    private static final Logger logger = LoggerFactory.getLogger(FloorPriceService.class);
    @Autowired
    private StringRedisTemplate nezhaStringRedisTemplate;
    private LoadingCache<BasePriceInfo, BasePriceResult> floorPriceFactorCache = CacheBuilder.newBuilder().refreshAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<BasePriceInfo, BasePriceResult>(){

        public BasePriceResult load(BasePriceInfo key) throws Exception {
            return FloorPriceService.this.loadCache(key, null);
        }

        public Map<BasePriceInfo, BasePriceResult> loadAll(Iterable<? extends BasePriceInfo> keys) {
            ArrayList basePriceInfos = Lists.newArrayList(keys);
            return FloorPriceService.this.loadAllCache(basePriceInfos);
        }

        public ListenableFuture<BasePriceResult> reload(BasePriceInfo key, BasePriceResult oldValue) throws Exception {
            ListenableFutureTask task = ListenableFutureTask.create(() -> FloorPriceService.this.loadCache(key, oldValue));
            FloorPriceService.this.executorService.submit((Runnable)task);
            return task;
        }
    });
    private LoadingCache<String, BasePriceParams> basePriceParamsCache = CacheBuilder.newBuilder().expireAfterWrite(2L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, BasePriceParams>(){

        public BasePriceParams load(String key) throws Exception {
            return FloorPriceService.this.loadBasePriceParamsCache(key).orElse(null);
        }

        public ListenableFuture<BasePriceParams> reload(String key, BasePriceParams oldValue) throws Exception {
            ListenableFutureTask task = ListenableFutureTask.create(() -> FloorPriceService.this.loadBasePriceParamsCache(key).orElse(oldValue));
            FloorPriceService.this.executorService.submit((Runnable)task);
            return task;
        }
    });

    private Optional<BasePriceParams> loadBasePriceParamsCache(String key) {
        try {
            DBTimeProfile.enter((String)"loadBasePriceParamsCache");
            Optional<BasePriceParams> optional = Optional.ofNullable(key).map(modelKey -> (String)this.nezhaStringRedisTemplate.opsForValue().get((Object)key)).map(json -> (BasePriceParams)JSON.parseObject((String)json, BasePriceParams.class));
            return optional;
        }
        catch (Exception e) {
            logger.error("load Base PriceParams,PriceParamsKey:{}", (Object)key);
            throw new RecommendEngineException("load Base Price Params exception", e);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    public Map<FloorPriceFeatureIndex, BasePriceResult> getFloorPriceFactor(AppDo appDo, List<OrientationPackage> floorPricePackages) {
        try {
            Map<FloorPriceFeatureIndex, BasePriceInfo> floorPriceFeatureIndexBasePriceInfoMap = this.buildBasePriceInfo(appDo, floorPricePackages);
            ImmutableMap priceFactorCacheAll = this.floorPriceFactorCache.getAll(floorPriceFeatureIndexBasePriceInfoMap.values());
            Map resultMap = MapUtils.translate(floorPriceFeatureIndexBasePriceInfoMap, (Map)priceFactorCacheAll);
            return resultMap;
        }
        catch (Exception e) {
            logger.warn("FloorPriceService#getFloorPriceFactor happend error!", (Throwable)e);
            return new HashMap<FloorPriceFeatureIndex, BasePriceResult>();
        }
    }

    private Map<FloorPriceFeatureIndex, BasePriceInfo> buildBasePriceInfo(AppDo appDo, List<OrientationPackage> floorPricePackages) {
        return ListToMapTools.toMap(floorPricePackages, orientationPackage -> FloorPriceFeatureIndex.conver(orientationPackage, appDo), orientationPackage -> this.getBasePriceInfo((OrientationPackage)orientationPackage, appDo));
    }

    private BasePriceInfo getBasePriceInfo(OrientationPackage orientationPackage, AppDo appDo) {
        BasePriceInfo basePriceInfo = new BasePriceInfo();
        Long advertId = orientationPackage.getAdvertId();
        Long packageId = orientationPackage.getId();
        Long slotId = appDo.getSlotId();
        basePriceInfo.setAdvertId(advertId);
        basePriceInfo.setOrientId(packageId);
        basePriceInfo.setAppId(appDo.getId());
        basePriceInfo.setSlotId(slotId);
        basePriceInfo.setAfee(orientationPackage.getConvertCost());
        basePriceInfo.setManageType(orientationPackage.getTargetAppLimit());
        return basePriceInfo;
    }

    private Map<BasePriceInfo, BasePriceResult> loadAllCache(List<BasePriceInfo> basePriceInfos) {
        int size = basePriceInfos.size();
        ArrayList allKeys = Lists.newArrayListWithCapacity((int)(size * 3));
        HashMap adPkSlKeys = Maps.newHashMapWithExpectedSize((int)size);
        HashMap adPkKeys = Maps.newHashMapWithExpectedSize((int)size);
        HashMap slKeys = Maps.newHashMapWithExpectedSize((int)size);
        String nowDate = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        basePriceInfos.forEach(basePriceInfo -> {
            Long advertId = basePriceInfo.getAdvertId();
            Long packageId = basePriceInfo.getOrientId();
            Long slotId = basePriceInfo.getSlotId();
            String adPkSlKey = RedisKeyUtil.getNezhaFloorPriceKey((Object[])new Object[]{advertId, packageId, slotId, nowDate});
            String adPkKey = RedisKeyUtil.getNezhaFloorPriceKey((Object[])new Object[]{advertId, packageId, nowDate});
            String slKey = RedisKeyUtil.getNezhaFloorPriceKey((Object[])new Object[]{slotId, nowDate});
            allKeys.add(adPkSlKey);
            adPkSlKeys.put(basePriceInfo, adPkSlKey);
            allKeys.add(adPkKey);
            adPkKeys.put(basePriceInfo, adPkKey);
            allKeys.add(slKey);
            slKeys.put(basePriceInfo, slKey);
        });
        Map statisticDataMap = StringRedisHelper.of((StringRedisTemplate)this.nezhaStringRedisTemplate).valueMultiGet((Iterable)allKeys, FloorPriceStatisticData.class, FloorPriceStatisticData::new);
        basePriceInfos.forEach(basePriceInfo -> {
            String adPkKey = (String)adPkKeys.get(basePriceInfo);
            this.setOrientSlotFloorPriceStatisticData((BasePriceInfo)basePriceInfo, adPkKey, statisticDataMap);
            String adPkSlKey = (String)adPkSlKeys.get(basePriceInfo);
            this.setOrientFloorPriceStatisticData((BasePriceInfo)basePriceInfo, adPkSlKey, statisticDataMap);
            String slKey = (String)slKeys.get(basePriceInfo);
            this.setSlotFloorPriceStatisticData((BasePriceInfo)basePriceInfo, slKey, statisticDataMap);
        });
        BasePriceParams basePriceParams = null;
        try {
            basePriceParams = (BasePriceParams)this.basePriceParamsCache.get((Object)RedisKeyUtil.getBasePriceParamsKey());
        }
        catch (ExecutionException e) {
            logger.error("basePriceParams load error !", (Throwable)e);
        }
        Map resultMap = BasePriceControl.basePriceControl(basePriceInfos, null, (BasePriceParams)basePriceParams);
        return ListToMapTools.toMap(basePriceInfos, Function.identity(), basePriceInfo -> resultMap.getOrDefault(basePriceInfo, new BasePriceResult()));
    }

    private BasePriceResult loadCache(BasePriceInfo basePriceInfo, BasePriceResult oldBasePriceResult) {
        Long advertId = basePriceInfo.getAdvertId();
        Long packageId = basePriceInfo.getOrientId();
        Long slotId = basePriceInfo.getSlotId();
        String nowDate = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String adPkSlKey = RedisKeyUtil.getNezhaFloorPriceKey((Object[])new Object[]{advertId, packageId, slotId, nowDate});
        String adPkKey = RedisKeyUtil.getNezhaFloorPriceKey((Object[])new Object[]{advertId, packageId, nowDate});
        String slKey = RedisKeyUtil.getNezhaFloorPriceKey((Object[])new Object[]{slotId, nowDate});
        ArrayList keys = Lists.newArrayList((Object[])new String[]{adPkKey, adPkSlKey, slKey});
        Map statisticDataMap = StringRedisHelper.of((StringRedisTemplate)this.nezhaStringRedisTemplate).valueMultiGet((Iterable)keys, FloorPriceStatisticData.class, FloorPriceStatisticData::new);
        this.setOrientFloorPriceStatisticData(basePriceInfo, adPkKey, statisticDataMap);
        this.setSlotFloorPriceStatisticData(basePriceInfo, slKey, statisticDataMap);
        this.setOrientSlotFloorPriceStatisticData(basePriceInfo, adPkSlKey, statisticDataMap);
        BasePriceParams basePriceParams = null;
        try {
            basePriceParams = (BasePriceParams)this.basePriceParamsCache.get((Object)RedisKeyUtil.getBasePriceParamsKey());
        }
        catch (ExecutionException e) {
            logger.error("basePriceParams load error !", (Throwable)e);
        }
        BasePriceResult basePriceResult = BasePriceControl.basePriceControl((BasePriceInfo)basePriceInfo, (BasePriceResult)oldBasePriceResult, (BasePriceParams)basePriceParams);
        return basePriceResult;
    }

    private void setOrientSlotFloorPriceStatisticData(BasePriceInfo basePriceInfo, String adPkKey, Map<String, FloorPriceStatisticData> statisticDataMap) {
        FloorPriceStatisticData adPkSlData = statisticDataMap.get(adPkKey);
        if (adPkSlData != null) {
            basePriceInfo.setOrientSlotCostToday(adPkSlData.getCostToday());
            basePriceInfo.setOrientSlotLaunchToday(adPkSlData.getLaunchToday());
            basePriceInfo.setOrientSlotLevel5PriceLaunchToday(adPkSlData.getLevel5PriceLaunchToday());
            basePriceInfo.setOrientSlotLevel10PriceLaunchToday(adPkSlData.getLevel10PriceLaunchToday());
            basePriceInfo.setOrientSlotLevel15PriceLaunchToday(adPkSlData.getLevel15PriceLaunchToday());
            basePriceInfo.setOrientSlotConvertToday(adPkSlData.getConvertToday());
            basePriceInfo.setOrientSlotBasePriceCostToday(adPkSlData.getPriceCostToday());
            basePriceInfo.setOrientSlotLaunchG3day(adPkSlData.getLaunchG3day());
        }
    }

    private void setSlotFloorPriceStatisticData(BasePriceInfo basePriceInfo, String slKey, Map<String, FloorPriceStatisticData> statisticDataMap) {
        FloorPriceStatisticData slData = statisticDataMap.get(slKey);
        if (slData != null) {
            basePriceInfo.setSlotCostToday(slData.getCostToday());
            basePriceInfo.setSlotLaunchToday(slData.getLaunchToday());
            basePriceInfo.setSlotLevel5PriceLaunchToday(slData.getLevel5PriceLaunchToday());
            basePriceInfo.setSlotLevel10PriceLaunchToday(slData.getLevel10PriceLaunchToday());
            basePriceInfo.setSlotLevel15PriceLaunchToday(slData.getLevel15PriceLaunchToday());
            basePriceInfo.setSlotBasePriceCostToday(slData.getPriceCostToday());
        }
    }

    private void setOrientFloorPriceStatisticData(BasePriceInfo basePriceInfo, String adPkKey, Map<String, FloorPriceStatisticData> statisticDataMap) {
        FloorPriceStatisticData adPkData = statisticDataMap.get(adPkKey);
        if (adPkData != null) {
            basePriceInfo.setOrientCostToday(adPkData.getCostToday());
            basePriceInfo.setOrientLaunchToday(adPkData.getLaunchToday());
            basePriceInfo.setOrientLevel5PriceLaunchToday(adPkData.getLevel5PriceLaunchToday());
            basePriceInfo.setOrientLevel10PriceLaunchToday(adPkData.getLevel10PriceLaunchToday());
            basePriceInfo.setOrientLevel15PriceLaunchToday(adPkData.getLevel15PriceLaunchToday());
            basePriceInfo.setOrientConvertToday(adPkData.getConvertToday());
            basePriceInfo.setOrientBasePriceCostToday(adPkData.getPriceCostToday());
        }
    }
}

