/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.biz.service.advert.rerank;

import cn.com.duiba.nezha.engine.api.enums.CPCAutoBiddingTypeEnum;
import cn.com.duiba.nezha.engine.biz.bo.advert.AdvertCPCAutoService;
import cn.com.duiba.nezha.engine.biz.domain.advert.OrientationPackage;
import cn.com.duiba.nezha.engine.biz.service.CacheService;
import cn.com.duiba.nezha.engine.common.utils.ListToMapTools;
import cn.com.duiba.nezha.engine.common.utils.MapUtils;
import cn.com.duiba.nezha.engine.common.utils.RedisKeyUtil;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service
@RefreshScope
public class AdvertReRankService
extends CacheService {
    @Value(value="${supportInfo}")
    private String supportInfo;
    private static final Integer ARTIFICIAL_MANAGED = 1;
    @Autowired
    private AdvertCPCAutoService advertCPCAutoService;

    public List<OrientationPackage> newReRank(List<OrientationPackage> orientationPackages, Long appId) {
        if (orientationPackages.isEmpty()) {
            return orientationPackages;
        }
        if (orientationPackages.size() == 1) {
            orientationPackages.get(0).setRank(0);
            orientationPackages.get(0).setReRank(0);
        }
        List<OrientationPackage> orientationPackageList = this.reRank(orientationPackages);
        return this.sortByCPCAuto(orientationPackageList, appId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OrientationPackage> reRank(List<OrientationPackage> orientationPackages) {
        try {
            DBTimeProfile.enter((String)"reRank");
            List<OrientationPackage> oldList = this.sortAndRank(orientationPackages);
            HashMap<Long, Long> advertSupportCount = new HashMap<Long, Long>();
            HashMap<Integer, Map<Long, SupportInfo>> supportInfoMap = new HashMap<Integer, Map<Long, SupportInfo>>();
            this.getSupportInfoAndCount(advertSupportCount, supportInfoMap);
            List<OrientationPackage> newList = this.calculateNewRankScoreAndSetRank(orientationPackages, advertSupportCount, supportInfoMap);
            OrientationPackage oldFirst = oldList.get(0);
            OrientationPackage newFirst = newList.get(0);
            if (oldFirst.equals(newFirst)) {
                List<OrientationPackage> list = oldList;
                return list;
            }
            Map accountSupportMap = supportInfoMap.getOrDefault(2, new HashMap());
            if (accountSupportMap.keySet().contains(oldFirst.getAccountId())) {
                double newArpu;
                SupportInfo supportInfo = (SupportInfo)accountSupportMap.get(oldFirst.getAccountId());
                int i = RandomUtils.nextInt((int)1, (int)101);
                if (i > supportInfo.getRate()) {
                    List<OrientationPackage> list = oldList;
                    return list;
                }
                double oldArpu = (double)oldFirst.getFinalFee().longValue() * oldFirst.getCtr();
                if ((oldArpu - (newArpu = (double)newFirst.getFinalFee().longValue() * newFirst.getCtr())) / oldArpu > supportInfo.getTolerance()) {
                    List<OrientationPackage> list = oldList;
                    return list;
                }
                List<OrientationPackage> list = newList;
                return list;
            }
            List<OrientationPackage> list = newList;
            return list;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private List<OrientationPackage> sortByCPCAuto(List<OrientationPackage> orientationPackages, Long appId) {
        OrientationPackage oldFirst = orientationPackages.get(0);
        List<OrientationPackage> newReqList = orientationPackages.stream().filter(data -> !CPCAutoBiddingTypeEnum.UN_OPENED.getCode().equals(data.getAutoBiddingType()) && ARTIFICIAL_MANAGED.equals(data.getPackageType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(newReqList)) {
            return orientationPackages;
        }
        orientationPackages.removeAll(newReqList);
        List<OrientationPackage> newRsultList = this.advertCPCAutoService.getAutoBidding(newReqList, appId);
        orientationPackages.addAll(newRsultList);
        List<OrientationPackage> newCpcList = orientationPackages.stream().sorted(Comparator.comparing(OrientationPackage::getRankScore).reversed()).collect(Collectors.toList());
        OrientationPackage newFirst = (OrientationPackage)newCpcList.get(0);
        if (!oldFirst.equals(newFirst)) {
            newFirst.setCpcAdjustPrice(true);
        }
        return newCpcList;
    }

    private List<OrientationPackage> sortAndRank(List<OrientationPackage> orientationPackages) {
        List<OrientationPackage> collect = orientationPackages.stream().sorted(Comparator.comparing(OrientationPackage::getRankScore).reversed()).collect(Collectors.toList());
        int size = collect.size();
        for (int r = 0; r < size; ++r) {
            OrientationPackage orientationPackage = collect.get(r);
            orientationPackage.setRank(r);
            orientationPackage.setSimpleSupportType("0");
        }
        return collect;
    }

    public static void main(String[] args) {
        String supportInfo = "47380:1:100:1:1.3:150000:2019-05-25;47291:1:100:1:1.3:150000:2019-05-25;45756:1:100:1:1.3:150000:2019-05-25;47412:1:100:1:1.5:150000:2019-05-25;46310:1:100:1:1.3:150000:2019-05-25;46301:1:100:1:1.3:150000:2019-05-25;46039:1:100:1:1.3:150000:2019-05-25;46038:1:100:1:1.3:150000:2019-05-25;47668:1:100:1:1.3:150000:2019-05-25;47585:1:100:1:1.3:150000:2019-05-25;48251:1:100:1:1.3:150000:2019-05-25;48252:1:100:1:1.3:150000:2019-05-25;48253:1:100:1:1.3:150000:2019-05-25;48254:1:100:1:1.3:150000:2019-05-25;46131:1:100:1:1.3:150000:2019-05-25;46599:1:100:1:1.3:150000:2019-05-25;47931:1:100:1:1.3:150000:2019-05-25;47968:1:100:1:0.8:150000:2019-05-25;46996:1:100:1:1.3:150000:2019-05-25;48563:1:100:1:1.3:150000:2019-05-25;47974:1:100:1:0.9:150000:2019-05-30;47237:1:100:1:0.9:150000:2019-05-30;44916:1:100:1:0.9:150000:2019-05-30;49147:1:100:1:1.3:100000:2019-05-30;15809:2:5:0.05:0.938:-1:2019-10-10;49344:1:100:1:1.5:100000:2019-05-30;47403:1:100:1:1.5:100000:2019-05-30;47361:1:100:1:1.5:100000:2019-05-30";
        Stream.of(supportInfo.split(";")).map(SupportInfo::parse).filter(si -> DateTime.now().withTimeAtStartOfDay().toDate().getTime() <= si.getEndDate().getTime()).collect(Collectors.groupingBy(SupportInfo::getType, Collectors.collectingAndThen(Collectors.toList(), list -> ListToMapTools.toMap((Collection)list, SupportInfo::getId, Function.identity()))));
    }

    private void getSupportInfoAndCount(Map<Long, Long> advertCount, Map<Integer, Map<Long, SupportInfo>> supportInfoMap) {
        if (StringUtils.isBlank((String)this.supportInfo)) {
            return;
        }
        supportInfoMap.putAll(Stream.of(this.supportInfo.split(";")).map(SupportInfo::parse).filter(si -> this.nowIsBefore(si.getEndDate())).collect(Collectors.groupingBy(SupportInfo::getType, Collectors.collectingAndThen(Collectors.toList(), list -> ListToMapTools.toMap((Collection)list, SupportInfo::getId, Function.identity())))));
        if (supportInfoMap.isEmpty()) {
            return;
        }
        Map advertSupportInfoMap = supportInfoMap.getOrDefault(1, new HashMap());
        if (advertSupportInfoMap.isEmpty()) {
            return;
        }
        Map advertKeyMap = ListToMapTools.toMap(advertSupportInfoMap.keySet(), Function.identity(), RedisKeyUtil::getSupportCount);
        ArrayList keys = Lists.newArrayList(advertKeyMap.values());
        List record = this.nezhaStringRedisTemplate.opsForValue().multiGet((Collection)keys);
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (int index = 0; index < record.size(); ++index) {
            String key = (String)keys.get(index);
            String value = (String)record.get(index);
            if (StringUtils.isNotBlank((String)value)) {
                map.put(key, Long.parseLong(value));
                continue;
            }
            map.put(key, 0L);
        }
        advertCount.putAll(MapUtils.translate((Map)advertKeyMap, map));
    }

    private Boolean nowIsBefore(Date date) {
        return DateTime.now().withTimeAtStartOfDay().toDate().getTime() <= date.getTime();
    }

    private List<OrientationPackage> calculateNewRankScoreAndSetRank(List<OrientationPackage> orientationPackages, Map<Long, Long> advertSupportCount, Map<Integer, Map<Long, SupportInfo>> supportInfoMap) {
        Map advertSupportInfoMap = supportInfoMap.getOrDefault(1, new HashMap());
        Map accountSupportInfoMap = supportInfoMap.getOrDefault(2, new HashMap());
        orientationPackages.forEach(orientationPackage -> {
            Long advertId = orientationPackage.getAdvertId();
            Long accountId = orientationPackage.getAccountId();
            Optional.ofNullable(advertSupportInfoMap.get(advertId)).ifPresent(advertSupportInfo -> {
                Long count = advertSupportCount.getOrDefault(advertId, 0L);
                if (count == -1L || count < advertSupportInfo.getCount()) {
                    orientationPackage.setRankScore(orientationPackage.getRankScore() * advertSupportInfo.getWeight());
                    orientationPackage.setSimpleSupportType(orientationPackage.getSimpleSupportType() + "1");
                    orientationPackage.setSupportInfoSupportWeight(advertSupportInfo.getWeight());
                }
            });
            Optional.ofNullable(accountSupportInfoMap.get(accountId)).ifPresent(accountSupportInfo -> {
                orientationPackage.setRankScore(orientationPackage.getRankScore() * accountSupportInfo.getWeight());
                orientationPackage.setSimpleSupportType(orientationPackage.getSimpleSupportType() + "2");
                orientationPackage.setSupportInfoSupportWeight(accountSupportInfo.getWeight());
            });
        });
        List<OrientationPackage> newList = orientationPackages.stream().sorted(Comparator.comparing(OrientationPackage::getRankScore).reversed()).collect(Collectors.toList());
        int size = newList.size();
        for (int r = 0; r < size; ++r) {
            OrientationPackage orientationPackage2 = newList.get(r);
            orientationPackage2.setReRank(r);
        }
        return newList;
    }

    public static class SupportInfo {
        private Long id;
        private Integer type;
        private Integer rate;
        private Double tolerance;
        private Double weight;
        private Long count;
        private Date endDate;

        private SupportInfo(Builder builder) {
            this.id = builder.id;
            this.type = builder.type;
            this.rate = builder.rate;
            this.tolerance = builder.tolerance;
            this.weight = builder.weight;
            this.count = builder.count;
            this.endDate = builder.endDate;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static SupportInfo parse(String supportInfo) {
            String[] split = supportInfo.split(":");
            long id = Long.parseLong(split[0]);
            int type = Integer.parseInt(split[1]);
            int rate = Integer.parseInt(split[2]);
            double tolerance = Double.parseDouble(split[3]);
            double weight = Double.parseDouble(split[4]);
            long count = Long.parseLong(split[5]);
            Date date = DateTime.parse((String)split[6]).toDate();
            return SupportInfo.newBuilder().id(id).type(type).rate(rate).tolerance(tolerance).weight(weight).count(count).endDate(date).build();
        }

        public Long getId() {
            return this.id;
        }

        public Integer getType() {
            return this.type;
        }

        public Integer getRate() {
            return this.rate;
        }

        public Double getWeight() {
            return this.weight;
        }

        public Long getCount() {
            return this.count;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public Double getTolerance() {
            return this.tolerance;
        }

        public static final class Builder {
            private Long id;
            private Integer type;
            private Integer rate;
            private Double tolerance;
            private Double weight;
            private Long count;
            private Date endDate;

            private Builder() {
            }

            public Builder id(Long val) {
                this.id = val;
                return this;
            }

            public Builder type(Integer val) {
                this.type = val;
                return this;
            }

            public Builder rate(Integer val) {
                this.rate = val;
                return this;
            }

            public Builder tolerance(Double val) {
                this.tolerance = val;
                return this;
            }

            public Builder weight(Double val) {
                this.weight = val;
                return this;
            }

            public Builder count(Long val) {
                this.count = val;
                return this;
            }

            public Builder endDate(Date val) {
                this.endDate = val;
                return this;
            }

            public SupportInfo build() {
                return new SupportInfo(this);
            }
        }
    }
}

