package cn.com.duiba.nezha.engine.common.utils;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: RoiHashKeyUtil.java , v 0.1 2017/7/25 下午4:54 ZhouFeng Exp $
 */
public class RoiHashKeyUtil {
    public static final String DEFAULT = "DEFAULT";

    public static final String APP = "APP";

    public static final String SLOT = "SLOT";

    public static final String ACTIVITY = "ACTIVITY";

    public static final String TAG = "TAG";

    public static String getDefault(Integer cvrType) {
        if (cvrType == null || cvrType.equals(0)) {
            return DEFAULT;
        }
        return DEFAULT + "_" + cvrType;
    }

    public static String getAppKey(Object appId, Integer cvrType) {
        if (cvrType == null || cvrType.equals(0)) {
            return APP + "_" + appId;
        }
        return APP + "_" + appId + "_" + cvrType;
    }

    public static String getSlotKey(Object slotId, Integer cvrType) {
        if (cvrType == null || cvrType.equals(0)) {
            return SLOT + "_" + slotId;
        }
        return SLOT + "_" + slotId + "_" + cvrType;
    }

    public static String getActivityKey(Object appId, String activityId, Integer cvrType) {
        if (cvrType == null || cvrType.equals(0)) {
            return ACTIVITY + "_" + appId + "_" + activityId;
        }
        return ACTIVITY + "_" + appId + "_" + activityId + "_" + cvrType;
    }

    public static String getTagAppKey(Object appId, String hitUserTag, Integer cvrType) {
        if (cvrType == null || cvrType.equals(0)) {
            return TAG + "_" + hitUserTag + "_" + appId;
        }
        return TAG + "_" + hitUserTag + "_" + appId + "_" + cvrType;
    }

    public static String getTagSlotKey(Object slotId, String hitUserTag, Integer cvrType) {
        if (cvrType == null || cvrType.equals(0)) {
            return TAG + "_" + hitUserTag + "_" + slotId;
        }
        return TAG + "_" + hitUserTag + "_" + slotId + "_" + cvrType;
    }

    public static String getTagKey(String hitUserTag, Integer cvrType) {
        if (cvrType == null || cvrType.equals(0)) {
            return TAG + "_" + hitUserTag;
        }
        return TAG + "_" + hitUserTag + "_" + cvrType;
    }


    private RoiHashKeyUtil(){
        //不允许创建实例
    }


}
