/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.common.utils;

import cn.com.duiba.nezha.engine.common.utils.HBaseField;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.FieldUtils;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;

public class HBaseResultCreater<T> {
    private final Logger logger = LoggerFactory.getLogger(HBaseResultCreater.class);
    private Result result;
    private Class<? extends T> resultType;
    private static final LoadingCache<Class<?>, Map<String, PropertyDescriptor>> CACHE = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Map<String, PropertyDescriptor>>(){

        public Map<String, PropertyDescriptor> load(Class<?> key) throws Exception {
            return HBaseResultCreater.mappingField(key);
        }
    });

    private HBaseResultCreater(Result result, Class<T> clazz) {
        this.result = result;
        this.resultType = clazz;
    }

    public static <T> HBaseResultCreater<T> of(Result result, Class<T> clazz) {
        return new HBaseResultCreater<T>(result, clazz);
    }

    public Optional<T> build() {
        Map fieldDescriptorMap;
        if (this.result == null || this.result.isEmpty()) {
            return Optional.empty();
        }
        if (this.resultType == null) {
            throw new IllegalArgumentException("resultType cannot be null");
        }
        Object bean = BeanUtils.instantiate(this.resultType);
        try {
            fieldDescriptorMap = (Map)CACHE.get(this.resultType);
        }
        catch (Exception e) {
            return Optional.empty();
        }
        List cells = this.result.listCells();
        BeanWrapper beanWrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)bean);
        for (Cell cell : cells) {
            String qualifier = new String(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)fieldDescriptorMap.get(qualifier);
            if (propertyDescriptor == null) continue;
            Object value = null;
            if (propertyDescriptor.getPropertyType().equals(Long.class)) {
                value = Bytes.toLong((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
            } else if (propertyDescriptor.getPropertyType().equals(String.class)) {
                value = new String(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
            } else if (propertyDescriptor.getPropertyType().equals(Double.class)) {
                String temp = new String(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
                value = Double.valueOf(temp);
            }
            if (value == null) continue;
            beanWrapper.setPropertyValue(propertyDescriptor.getName(), value);
        }
        return Optional.of(bean);
    }

    public static Map<String, PropertyDescriptor> mappingField(Class<?> resultType) {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(resultType);
        HashMap<String, PropertyDescriptor> fieldDescriptorMap = new HashMap<String, PropertyDescriptor>(propertyDescriptors.length);
        for (PropertyDescriptor descriptor : propertyDescriptors) {
            String alias;
            HBaseField annotation;
            String fieldName = descriptor.getName();
            fieldDescriptorMap.put(fieldName, descriptor);
            fieldDescriptorMap.put(HBaseResultCreater.camelCase2SnakeCase(fieldName), descriptor);
            Field field = FieldUtils.getField(resultType, (String)fieldName, (boolean)true);
            if (field == null || (annotation = field.getAnnotation(HBaseField.class)) == null || !StringUtils.isNotBlank((String)(alias = annotation.alias()))) continue;
            fieldDescriptorMap.put(alias, descriptor);
        }
        return fieldDescriptorMap;
    }

    private static String camelCase2SnakeCase(String camelCaseName) {
        char[] chars = camelCaseName.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (char aChar : chars) {
            if (Character.isUpperCase(aChar)) {
                sb.append("_");
                aChar = Character.toLowerCase(aChar);
            }
            sb.append(aChar);
        }
        return sb.toString();
    }
}

