/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.common.utils;

import cn.com.duiba.nezha.engine.api.enums.RedisKey;
import com.google.common.base.Joiner;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

public class RedisKeyUtil {
    private static final String SEPARATOR = "_";
    private static final String NZ_PREFIX = "NZ";
    private static final String TUIA_PREFIX = "TUIA";
    private static final String HELPBYSELF_PARAMS_KEY = "NZ_K86_helpbyself_params";

    public static String roiClickKey(String advertId, String packageId) {
        return RedisKeyUtil.getKey(RedisKey.K37, advertId, packageId, LocalDate.now());
    }

    public static String roiFeeKey(String advertId, String packageId, LocalDate localDate) {
        return RedisKeyUtil.getKey(RedisKey.K38, advertId, packageId, localDate);
    }

    public static String roiCvrKey(String advertId, String packageId, LocalDate localDate) {
        return RedisKeyUtil.getKey(RedisKey.K39, advertId, packageId, localDate);
    }

    public static String roiBackendCvrKey(String advertId, String packageId, LocalDate localDate) {
        return RedisKeyUtil.getKey(RedisKey.K41, advertId, packageId, localDate);
    }

    public static String roiClickLockKey(String advertId, String packageId) {
        return RedisKeyUtil.getKey(RedisKey.K40, advertId, packageId);
    }

    public static String recentlyClickKey(String advertId, String packageId) {
        return RedisKeyUtil.getKey(RedisKey.K43, advertId, packageId, LocalDate.now());
    }

    public static String advertStatFeatureKey(Long appId, Long activityId, Long slotId, Long advertId) {
        String newKey = RedisKeyUtil.getNewKey(advertId, appId, null, null, activityId, slotId, null, null);
        return RedisKeyUtil.getKey(RedisKey.K44, newKey);
    }

    public static String advertMergeStatKey(Long appId, Long advertId, Long materialId, Long times) {
        String newKey = RedisKeyUtil.getNewKey(advertId, appId, materialId, times, null, null, null, null);
        return RedisKeyUtil.getKey(RedisKey.K46, newKey);
    }

    public static String advertDailyStatKey(Long appId, Long advertId, Long packageId, Long materialId, Long tag, String timestamp) {
        String newKey = RedisKeyUtil.getNewKey(advertId, appId, materialId, null, null, null, packageId, tag);
        return RedisKeyUtil.getKey(RedisKey.K47, newKey, timestamp);
    }

    public static String advertHourlyStatKey(Long appId, Long advertId, Long packageId, Long materialId, String timestamp) {
        String newKey = RedisKeyUtil.getNewKey(advertId, appId, materialId, null, null, null, packageId, null);
        return RedisKeyUtil.getKey(RedisKey.K48, newKey, timestamp);
    }

    public static String materialRankList(Long appId, Long advertId) {
        return RedisKeyUtil.getKey(RedisKey.K045, appId, advertId);
    }

    public static String factorKey(Long advertId, Long packageId, String suffix) {
        return RedisKeyUtil.getKey(RedisKey.K55, advertId, packageId, suffix);
    }

    public static String tagDailyStatKey(Long appId, String tagId, String timestamp) {
        return RedisKeyUtil.getKey(RedisKey.K60, appId, tagId, timestamp);
    }

    public static String tagHourlyStatKey(Long appId, String tagId, String timestamp) {
        return RedisKeyUtil.getKey(RedisKey.K61, appId, tagId, timestamp);
    }

    public static String getNezhaStatKey(Long algType, Long advertId, Long appId) {
        return RedisKeyUtil.getKey(RedisKey.K66, algType, advertId, appId);
    }

    public static String getNezhaStatKey(RedisKey redisKey, Long algType, Long advertId, Long appId, Long slotId) {
        return RedisKeyUtil.getKey(redisKey, algType, advertId, slotId, appId);
    }

    public static String getBlackWhiteKey(Long appId, Long slotId, Long activityId, Long orientationId, Long advertId) {
        return RedisKeyUtil.getKey(RedisKey.K73, appId, slotId, activityId, orientationId, advertId);
    }

    public static String getNewBlackWhiteKey(Long advertId, Long orientationId) {
        return RedisKeyUtil.getKey(RedisKey.K75, advertId, orientationId);
    }

    public static String getSlotAdvertInfoKey(Long slotId, Long advertId) {
        return RedisKeyUtil.getKey(RedisKey.K76, slotId, advertId);
    }

    public static String getSlotPackageDataKey(Long slotId, Long advertId, Long orientationId, Long fee, String timestamp) {
        return RedisKeyUtil.getKey(RedisKey.K84, slotId, advertId, orientationId, fee, timestamp);
    }

    public static String getSlotAdvertDataKey(Long slotId, Long advertId, String timestamp) {
        return RedisKeyUtil.getKey(RedisKey.K89, slotId, advertId, timestamp);
    }

    public static String getAccountConsumeKey(Long accountId) {
        return RedisKeyUtil.getKey(RedisKey.K78, accountId);
    }

    public static String getAdvertOrientationAppConsumeKey(Long advertId, Long orientationId, Long appId) {
        return RedisKeyUtil.getKey(RedisKey.K79, advertId, orientationId, appId);
    }

    public static String getAdvertOrientationHourConsumeKey(Long advertId, Long orientationId) {
        return RedisKeyUtil.getKey(RedisKey.K80, advertId, orientationId);
    }

    public static String getAdvertOrientationConsumeKey(Long advertId, Long orientationId) {
        return RedisKeyUtil.getKey(RedisKey.K81, advertId, orientationId);
    }

    public static String getAdvertConsumeKey(Long advertId) {
        return RedisKeyUtil.getKey(RedisKey.K82, advertId);
    }

    public static String getActivityFeatureKey(Long activityId) {
        return RedisKeyUtil.getKey(RedisKey.K83, activityId);
    }

    public static String getOrientationPackageData(Long advertId, Long packageId, String timestamp) {
        return RedisKeyUtil.getKey(RedisKey.K85, advertId, packageId, timestamp);
    }

    public static String getOrientationPackageSupportData(Long advertId, Long packageId, String timestamp) {
        return RedisKeyUtil.getKey(RedisKey.K87, advertId, packageId, timestamp);
    }

    public static String getOrientationPackageSlotSupportData(Long slot, Long advertId, Long packageId, String timestamp) {
        return RedisKeyUtil.getKey(RedisKey.K88, slot, advertId, packageId, timestamp);
    }

    public static String getSupportCount(Long advertId) {
        return RedisKeyUtil.getKey(RedisKey.K91, advertId, LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
    }

    public static String getNezhaRescureKey(Long advertId, Long orientId) {
        return RedisKeyUtil.getKey(RedisKey.K92, advertId, orientId);
    }

    public static String getNezhaRescureAppKey(Long advertId, Long orientId, Long appId) {
        return RedisKeyUtil.getKey(RedisKey.K93, advertId, orientId, appId);
    }

    public static String getNezhaRescureSlotKey(Long advertId, Long orientId, Long slotId) {
        return RedisKeyUtil.getKey(RedisKey.K94, advertId, orientId, slotId);
    }

    public static String getNezhaFloorPriceKey(Object ... objects) {
        return RedisKeyUtil.getKey(NZ_PREFIX, RedisKey.K95, objects);
    }

    public static String getTradeFeatureAdvertTrade(String advertTradeId) {
        return RedisKeyUtil.getKey(RedisKey.K96, advertTradeId);
    }

    public static String getTradeFeatureAppTrade(String appTradeId) {
        return RedisKeyUtil.getKey(RedisKey.K97, appTradeId);
    }

    public static String getTradeFeatureAppId(Long appId) {
        return RedisKeyUtil.getKey(RedisKey.K98, appId);
    }

    public static String getTradeFeatureAdvertId(Long advertId) {
        return RedisKeyUtil.getKey(RedisKey.K99, advertId);
    }

    public static String getHelpbyselfParamsKey() {
        return HELPBYSELF_PARAMS_KEY;
    }

    public static String getTrusteeshipParamsKey() {
        return RedisKeyUtil.getKey(RedisKey.K86, "trusteeship_params");
    }

    public static String getBasePriceParamsKey() {
        return RedisKeyUtil.getKey(RedisKey.K86, "basepricecontrol_params");
    }

    public static String getArpuOptimizeFactorKey() {
        return RedisKeyUtil.getKey(RedisKey.K86, "arpuoptalpha_params");
    }

    public static String getCpcAutoBiddingParamsKey() {
        return RedisKeyUtil.getKey(RedisKey.K86, "cpcautobidding_params");
    }

    public static String getBudgetQueryKey(Long appId, Long advertId, Long packageId, String timestamp) {
        if (appId != null) {
            return RedisKeyUtil.getKey(RedisKey.K90, appId, advertId, packageId, timestamp);
        }
        return RedisKeyUtil.getKey(RedisKey.K90, advertId, packageId, timestamp);
    }

    public static String getCPCAutoKey(Long advertId, Long packageId, Long appId, String timestamp) {
        if (appId != null) {
            return RedisKeyUtil.getKey(RedisKey.K100, advertId, packageId, appId, timestamp);
        }
        return RedisKeyUtil.getKey(RedisKey.K100, advertId, packageId, timestamp);
    }

    private static String getKey(RedisKey redisKey, Object ... objects) {
        return RedisKeyUtil.getKey(NZ_PREFIX, redisKey, objects);
    }

    private static String getKey(String prefix, RedisKey redisKey, Object ... objects) {
        Joiner joiner = Joiner.on((String)SEPARATOR).skipNulls();
        ArrayList<String> items = new ArrayList<String>();
        items.add(prefix);
        items.add((String)redisKey);
        items.addAll(Arrays.stream(objects).map(value -> value == null ? "null" : value).collect(Collectors.toList()));
        return joiner.join(items);
    }

    private static String getNewKey(Long advertId, Long appId, Long materialId, Long advertTimes, Long activityId, Long slotId, Long orientationId, Long tag) {
        StringBuilder sb = new StringBuilder();
        String split = SEPARATOR;
        if (advertId != null) {
            sb.append(DataType.ADVERT.getIndex()).append(split).append(advertId).append(split);
        }
        if (appId != null) {
            sb.append(DataType.APP.getIndex()).append(split).append(appId).append(split);
        }
        if (materialId != null) {
            sb.append(DataType.MATERIAL.getIndex()).append(split).append(materialId).append(split);
        }
        if (advertTimes != null) {
            sb.append(DataType.ADVERT_TIMES.getIndex()).append(split).append(advertTimes).append(split);
        }
        if (activityId != null) {
            sb.append(DataType.ACTIVITY.getIndex()).append(split).append(activityId).append(split);
        }
        if (slotId != null) {
            sb.append(DataType.SLOT.getIndex()).append(split).append(slotId).append(split);
        }
        if (orientationId != null) {
            sb.append(DataType.ORIENTATION.getIndex()).append(split).append(orientationId).append(split);
        }
        if (tag != null) {
            sb.append(DataType.FLOW_TAG.getIndex()).append(split).append(tag).append(split);
        }
        String s = sb.toString();
        return s.substring(0, s.length() - split.length());
    }

    private RedisKeyUtil() {
    }

    static enum DataType {
        ADVERT("advert", "1"),
        APP("app", "2"),
        MATERIAL("material", "3"),
        ADVERT_TIMES("advert_times", "4"),
        ACTIVITY("activity", "5"),
        SLOT("slot", "6"),
        ORIENTATION("orientation", "7"),
        FLOW_TAG("flowTag", "8");

        private String name;
        private String index;

        private DataType(String name, String index) {
            this.name = name;
            this.index = index;
        }

        public String getName() {
            return this.name;
        }

        public String getIndex() {
            return this.index;
        }
    }
}

