package cn.com.duiba.nezha.engine.deploy.controller;

import cn.com.duiba.nezha.alg.alg.vo.BiddingRateDo;
import cn.com.duiba.nezha.engine.biz.bo.advert.AdvertCPCAutoService;
import cn.com.duiba.nezha.engine.biz.domain.advert.OrientationPackage;
import cn.com.duiba.nezha.engine.biz.service.advert.ctr.NewAdvertSupportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

@RestController
public class TestController {
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    @Autowired
    private NewAdvertSupportService newAdvertSupportService;

    @Autowired
    private AdvertCPCAutoService advertCPCAutoService;

    @RequestMapping("/test")
    public void test() {

        long l = System.currentTimeMillis();
        for (int i = 0; i < 10000; i++) {
            LocalDateTime.parse("2018-09-01 11:11:11", DATE_TIME_FORMATTER);
        }
        long l1 = System.currentTimeMillis();
        System.out.println(l1 - l);


        long l2 = System.currentTimeMillis();
        for (int i = 0; i < 10000; i++) {
            LocalDateTime.parse("2018-09-01 11:11:11", DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        long l3 = System.currentTimeMillis();
        System.out.println(l3 - l2);
    }

    @RequestMapping(value = "/getBiddingRateByGuave", method = RequestMethod.POST)
    @ResponseBody
    public BiddingRateDo getBiddingRate(NewAdvertSupportService.BiddingKey biddingKey){
        return newAdvertSupportService.getBiddingRate(biddingKey);
    }

    @RequestMapping(value = "/getAutoBidding", method = RequestMethod.POST)
    @ResponseBody
    public String getAutoBidding(){

        List<OrientationPackage> newCPCList = new ArrayList<>();

        OrientationPackage orientationPackage = new OrientationPackage();
        orientationPackage.setId(111L);
        orientationPackage.setAdvertId(222L);
        orientationPackage.setCvrType(1);
        orientationPackage.setAutoBiddingType(1);
        orientationPackage.setFinalFee(100L);
        orientationPackage.setRankScore(1d);

        newCPCList.add(orientationPackage);
        Long appId = 19003L;

        advertCPCAutoService.getAutoBidding(newCPCList, appId);

        return "ok";
    }

}
