/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.odps.center.api.param.common;

import cn.com.duiba.api.bo.page.PageQuery;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GenericQueryParam
extends PageQuery {
    private static final long serialVersionUID = 1L;
    private String tableName;
    private List<String> selectFields;
    private Map<String, Object> conditions = new HashMap<String, Object>();
    private Map<String, String> orderBy = new HashMap<String, String>();
    private Boolean distinct;
    private List<String> groupBy;
    private Long lastId;
    private String idFieldName = "id";
    private String resultType;

    public GenericQueryParam() {
    }

    public GenericQueryParam(String tableName) {
        this();
        this.tableName = tableName;
    }

    public GenericQueryParam addEqualCondition(String field, Object value) {
        if (value != null) {
            this.conditions.put(field, value);
        }
        return this;
    }

    public GenericQueryParam addInCondition(String field, List<String> values) {
        if (values != null && !values.isEmpty()) {
            this.conditions.put(field, new InCondition(values));
        }
        return this;
    }

    public GenericQueryParam addDateRangeCondition(String field, Date startTime, Date endTime) {
        if (startTime != null || endTime != null) {
            this.conditions.put(field, new DateRangeCondition(startTime, endTime));
        }
        return this;
    }

    public GenericQueryParam addLikeCondition(String field, String value) {
        if (value != null && !value.isEmpty()) {
            this.conditions.put(field, new LikeCondition(value));
        }
        return this;
    }

    public GenericQueryParam addOrderBy(String field, String direction) {
        if (field != null && direction != null) {
            this.orderBy.put(field, direction.toUpperCase());
        }
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<String> getSelectFields() {
        return this.selectFields;
    }

    public void setSelectFields(List<String> selectFields) {
        this.selectFields = selectFields;
    }

    public Map<String, Object> getConditions() {
        return this.conditions;
    }

    public void setConditions(Map<String, Object> conditions) {
        this.conditions = conditions;
    }

    public Map<String, String> getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(Map<String, String> orderBy) {
        this.orderBy = orderBy;
    }

    public Boolean getDistinct() {
        return this.distinct;
    }

    public void setDistinct(Boolean distinct) {
        this.distinct = distinct;
    }

    public List<String> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(List<String> groupBy) {
        this.groupBy = groupBy;
    }

    public Long getLastId() {
        return this.lastId;
    }

    public void setLastId(Long lastId) {
        this.lastId = lastId;
    }

    public String getIdFieldName() {
        return this.idFieldName;
    }

    public void setIdFieldName(String idFieldName) {
        this.idFieldName = idFieldName;
    }

    public String getResultType() {
        return this.resultType;
    }

    public void setResultType(String resultType) {
        this.resultType = resultType;
    }

    public GenericQueryParam setResultType(Class<?> clazz) {
        if (clazz != null) {
            this.resultType = clazz.getName();
        }
        return this;
    }

    public static class LikeCondition
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String value;

        public LikeCondition(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class DateRangeCondition
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Date startTime;
        private Date endTime;

        public DateRangeCondition(Date startTime, Date endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public Date getEndTime() {
            return this.endTime;
        }
    }

    public static class InCondition
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<String> values;

        public InCondition(List<String> values) {
            this.values = values;
        }

        public List<String> getValues() {
            return this.values;
        }
    }
}

