package cn.com.duiba.oto.dto.oto.content;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * oto内容表
 *
 * @TableName tb_oto_content
 */
@Data
public class ContentDto implements Serializable {

    private static final long serialVersionUID = -6682044081461802269L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 内容类型 1:视频
     */
    private Integer contentType;

    /**
     * 内容状态 0：下架 1：上架
     */
    private Integer contentStatus;

    /**
     * 内容标题
     */
    private String contentTitle;

    /**
     * 内容描述
     */
    private String contentDesc;

    /**
     * 内容链接
     */
    private String contentUrl;

    /**
     * 内容图片
     */
    private String contentImage;

    /**
     * 作者
     */
    private String contentAuthor;

    /**
     * 作者头像
     */
    private String authorImage;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}