package cn.com.duiba.oto.dto.oto.pet;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * tb_oto_pet
 *
 * @author
 */
@Data
public class OtoPetOrderDto implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 主订单ID
     */
    private Long id;
    /**
     * 主订单编号
     */
    private String orderNo;
    /**
     * 微信用户ID
     */
    private Long userId;
    /**
     * 服务地址ID
     */
    private Long addressId;
    /**
     * 应付金额（单位：分）
     */
    private Long payAmount;
    /**
     * 优惠金额（单位：分）
     */
    private Long discountAmount;
    /**
     * 原价总金额（单位：分）
     */
    private Long totalAmount;
    /**
     * 订单状态：0=待支付，1=已支付，2=服务中，3=已完成，4=已取消
     */
    private Integer orderStatus;
    /**
     * 支付时间
     */
    private Date payTime;
    /**
     * 完成时间
     */
    private Date finishTime;
    /**
     * 退款时间
     */
    private Date refundTime;
    /**
     * 取消原因
     */
    private String cancelReason;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
    /**
     * 订单备注
     */
    private String orderRemark;
}