package cn.com.duiba.oto.dto.oto.pet;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2025/4/12 13:11
 * @Description:
 */
@Data
public class RemotePetOrderListItemDto implements Serializable {
    private static final long serialVersionUID = -1953540534342168751L;
    /**
     * 订单ID
     */
    private Long orderId;
    /**
     * 主订单编号
     */
    private String orderNo;
    /**
     * 服务类型
     * @see cn.com.duiba.oto.enums.pet.PetServiceTypeEnum
     */
    private Integer serviceType;
    /**
     * 用户昵称
     */
    private String userNickname;
    /**
     * 客户姓名
     */
    private String customerName;
    /**
     * 客户手机号
     */
    private String phone;
    /**
     * 服务地址
     */
    private String address;
    /**
     * 服务项目
     */
    private List<String> serviceItems;
    /**
     * 订单金额
     * 分
     */
    private Long amount;
    /**
     * 下单时间
     */
    private Date createTime;
    /**
     * 完成时间
     */
    private Date finishTime;
    /**
     * 退款时间
     */
    private Date refundTime;
    /**
     * 订单状态
     * 1=待服务, 2=已完成
     */
    private Integer status;
    /**
     * 服务时间段，如 "10:00-12:00"
     */
    private String appointmentTimeRange;
    /**
     * 开门方式：1=密码锁，2=存放快递柜，3=家中有人，4=其他
     */
    private Integer doorType;
    /**
     * 匹配时间
     */
    private Date matchTime;
}
