package cn.com.duiba.oto.enums.activity;

import cn.com.duiba.oto.bean.activity.biz.BaseParamBean;
import cn.com.duiba.oto.bean.activity.biz.PetParamBean;
import cn.com.duiba.oto.bean.activity.biz.PhotoParamBean;
import cn.com.duiba.oto.bean.activity.biz.WuyeActivityParamBean;
import cn.com.duiba.oto.bean.activity.biz.YiYuanParamBean;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * biz活动类型枚举
 *
 * @author xiaotian
 * @Description
 */
@Getter
public enum BizActivityTypeEnum {
    /**
     * 一元购
     */
    YI_YUAN("1", YiYuanParamBean.class),
    /**
     * 摄影投票第一期
     */
    PHOTO("2", PhotoParamBean.class),
    /**
     * 未实现配置化，第二期还是新增type临时解决
     */
    PHOTO_V2("3", PhotoParamBean.class),
    /**
     * 摄影投票通用（多期）
     */
    PHOTO_V3("4", PhotoParamBean.class),
    /**
     * 宠物投票
     */
    PET("5", PetParamBean.class),
    /**
     * 物业活动（多期）
     */
    WUYE_AVTIVITY("6", WuyeActivityParamBean.class),
    ;


    private static final Map<String, BizActivityTypeEnum> INNER_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(BizActivityTypeEnum::getType, Function.identity(), (v1, v2) -> v1)));


    private final String type;

    private final Class<? extends BaseParamBean> beanClass;

    BizActivityTypeEnum(String type, Class<? extends BaseParamBean> beanClass) {
        this.type = type;
        this.beanClass = beanClass;
    }

    public static BizActivityTypeEnum getByType(String type) {
        return INNER_MAP.getOrDefault(type, null);
    }

    public String getType() {
        return type;
    }

    public Class<? extends BaseParamBean> getBeanClass() {
        return beanClass;
    }
}
