package cn.com.duiba.oto.enums.pet;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 宠物洗护基本价格类型枚举
 *
 * @author xiaotian
 */
@Getter
@AllArgsConstructor
public enum PetWashBaseEnum {

    //短毛猫
    SHORT_HAIR_CAT(1, 14800L, 8800L, "短毛猫"),
    //长毛猫
    LONG_HAIR_CAT(2, 16800L, 9800L, "长毛猫"),
    //小型犬
    SMALL_DOG(3, 8000L, 6600L, "小型犬"),
    //中型犬
    MEDIUM_DOG(4, 10800L, 8800L, "中型犬"),
    //大型犬
    BIG_DOG(5, 18800L, 15800L, "大型犬"),
    ;

    private static final Map<Integer, String> CUSTOMER_TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(PetWashBaseEnum::getCode, PetWashBaseEnum::getDesc, (v1, v2) -> v1)));
    private Integer code;
    //常规价
    private Long price;
    //首单价
    private Long firstPrice;
    private String desc;

    public Long getPrice() {
        if (SpringEnvironmentUtils.isProdEnv()) {
            return price;
        } else {
            return price / 1000;
        }
    }

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return "";
        }
        return CUSTOMER_TYPE_MAP.get(code);
    }
}
