package cn.com.duiba.oto.oto.service.api.remoteservice.amount;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.base.api.request.PageResult;
import cn.com.duiba.oto.dto.oto.amount.ConsumeAmountDataParam;
import cn.com.duiba.oto.dto.oto.amount.ExpireAmountRecord;
import cn.com.duiba.oto.dto.oto.amount.ExpireAmountRecordNewDto;
import cn.com.duiba.oto.dto.oto.amount.ExpireTotalQuery;
import cn.com.duiba.oto.dto.oto.amount.QueryRecordParam;
import cn.com.duiba.oto.dto.oto.amount.QueryUserParam;
import cn.com.duiba.oto.dto.oto.amount.UserExpireAmountDto;
import cn.com.duiba.oto.dto.oto.amount.UserRemainAmountDto;
import cn.com.duiba.oto.param.oto.amount.QueryAmountTimeParam;

import java.util.List;

/**
 * 立减金(会过期)remote
 *
 * @author songp
 * @date 2024/8/14 11:25 AM
 */
@AdvancedFeignClient
public interface RemoteExpireAmountRecordService {

    /**
     * 插入一条记录
     *
     * @param recordDto 记录
     * @return 大于0条操作成功
     */
    int insert(ExpireAmountRecordNewDto recordDto);

    /**
     * 获取用户剩余立减金
     *
     * @param userId 用户ID
     * @return 立减金
     */
    UserRemainAmountDto getUserRemainAmount(String userId);

    /**
     * 扣除用户立减金
     *
     * @param dataParam 入参
     * @return 为true-扣除成功
     */
    boolean consumeUserRemainAmount(ConsumeAmountDataParam dataParam);

    /**
     * 查询用户全部立减金记录
     *
     * @param param 参数
     * @return 立减金记录
     */
    PageResult<ExpireAmountRecord> pageQueryExpireAmountRecords(QueryRecordParam param);

    /**
     * 获取用户的立减金汇总
     *
     * @param userId 用户ID
     * @return 立减金汇总
     */
    UserExpireAmountDto getUserExpireAmountTotal(String userId);

    /**
     * 查询指定时间段内指定来源的记录数量
     *
     * @param param 参数
     * @return 筛选到的记录条数
     */
    int selectForTimeSource(QueryAmountTimeParam param);

    /**
     * 查询指定时间段内指定来源的记录
     *
     * @param param 参数
     * @return 筛选到的记录条数
     */
    List<ExpireAmountRecord> selectListForTimeSource(QueryAmountTimeParam param);

    /**
     * 获取指定时间内将过期未使用立减金总额
     * @param param 参数
     * @return 将过期未使用立减金总额(分)
     */
    long getFutureExpireAmountCount(ExpireTotalQuery param);

    /**
     * 根据userId 的list，获取用户的可用立减金总额
     */
    List<UserExpireAmountDto> getUserExpireAmountTotalByList(List<String> userId);

    /**
     * 搜索已经获取过立减金的客户（userId）列表
     */
    PageResult<String> searchUserIdList(QueryUserParam param);
}
