package cn.com.duiba.oto.oto.service.api.remoteservice.cust;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.cust.CustPhaseExtDto;

import java.util.List;

/**
 * @Author meichang
 * @Date 2022/5/18 17:35
 * @Version 1.0
 */
@AdvancedFeignClient
public interface RemoteOtoCustPhaseService {
    /**
     * 根据客户id查询客户阶段信息
     * @param custId
     * @return
     */
    CustPhaseExtDto selectByCustId(Long custId);

    /**
     * 根据客户id查询客户阶段信息
     * @param dealFlag
     */
    List<CustPhaseExtDto> selectByDealFlag(Integer dealFlag);


    /**
     * 更新客户阶段信息
     * @param extDTO
     * @return
     */
    Boolean updateCustPhase(CustPhaseExtDto extDTO);

    /**
     * 更新客户阶段信息（标记成单专用）
     *
     * @param extDTO
     * @return
     */
    Boolean updateCustPhaseByCustId(CustPhaseExtDto extDTO);

    /**
     * 根据客户id 查询客户阶段信息
     * @param custIds
     */
    List<CustPhaseExtDto> listCustPhaseExtListByCustIds(List<Long> custIds);

    /**
     * 批量写入客户阶段信息
     * @param custPhaseExtDtos
     * @return
     */
    Boolean batchInsertByExcel(List<CustPhaseExtDto> custPhaseExtDtos);

    /**
     * 批量更新客户阶段信息
     * @param custPhaseExtDtos
     * @return
     */
    Boolean batchUpdateCustPhase(List<CustPhaseExtDto> custPhaseExtDtos);
}
