package cn.com.duiba.oto.oto.service.api.remoteservice.wx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.param.oto.wx.OfficialAccountParam;

/**
 * 功能描述：AccessToken获取
 *
 * @Auther: xiaotian
 * @Date: 2023/1/29 16:52
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteAccessTokenService {

    /**
     * 根据oaID获取access_token
     *
     * @param oaId 公众号ID
     * @return access_token
     */
    String getAccessTokenByOaId(Long oaId);

    /**
     * 根据appID获取access_token
     *
     * @param appId 公众号appId
     * @return access_token
     */
    String getAccessTokenByAppId(String appId);


    /**
     * 根据oa获取access_token
     *
     * @param officialAccountParam 公众号对象。必须包含app ID和appSecret
     * @return access_token
     */
    String getAccessTokenByOa(OfficialAccountParam officialAccountParam);

    /**
     * 刷新accessToken 并返回最新的token
     *
     * @param oaId 公众号ID
     * @return
     */
    String refreshAccessToken(Long oaId, String oldToken);

}
