package cn.com.duiba.oto.bean.wx;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2025/4/21 15:55
 * @Description:
 */

import lombok.Data;

import java.util.List;

/**
 * 企业微信机器人消息参数对象 (仅支持文本消息)
 */
@Data
public class WeComRobotMessage {

    // 消息类型
    private String msgtype = "text";

    // 文本消息内容
    private Text text;

    // 被@的成员列表
    private List<String> mentionedList;

    // 被@的手机号列表
    private List<String> mentionedMobileList;

    // 快速创建文本消息的静态方法
    public static WeComRobotMessage createTextMessage(String content) {
        WeComRobotMessage message = new WeComRobotMessage();
        message.setText(new Text(content));
        return message;
    }

    // 快速创建带@的文本消息的静态方法
    public static WeComRobotMessage createTextMessage(String content, List<String> mentionedList, List<String> mentionedMobileList) {
        WeComRobotMessage message = new WeComRobotMessage();
        message.setText(new Text(content));
        message.setMentionedList(mentionedList);
        message.setMentionedMobileList(mentionedMobileList);
        return message;
    }

    // 文本消息内容内部类
    public static class Text {
        private String content;

        public Text(String content) {
            this.content = content;
        }

        public String getContent() {
            return content;
        }

        public void setContent(String content) {
            this.content = content;
        }
    }
}