package cn.com.duiba.oto.dto.oto.pet.order;

import com.alibaba.fastjson.JSON;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 宠物线下订单表
 * @TableName tb_pet_offline_orders
 */
@Data
public class PetOfflineOrdersDto implements Serializable {
    private static final long serialVersionUID = 3194789853609807740L;
    /**
     * 主键ID
     */
    private Long id;

    /**
     * 订单编号
     */
    private String orderNo;

    /**
     * 地址和联系人信息 (JSON 对象)
     */
    private String addressInfo;

    /**
     * 宠物信息 (JSON 数组)
     */
    private String pets;

    /**
     * 服务日期
     */
    private Date appointmentDate;

    /**
     * 服务时间段
     */
    private String appointmentTimeRange;

    /**
     * 1:上午 2:下午 3:晚上
     */
    private Integer appointmentTimeSlot;

    /**
     * 服务类型 (1:喂养, 2:洗护)
     */
    private Integer serviceType;

    /**
     * 订单状态 (0=待服务, 1=已服务, 2=用户取消, 3=商家取消)
     */
    private Integer orderStatus;

    /**
     * 应付金额(单位:分)
     */
    private Long payAmount;

    /**
     * 原价总金额(单位:分)
     */
    private Long totalAmount;

    /**
     * 优惠金额(单位:分)
     */
    private Long discountAmount;

    /**
     * 完成时间
     */
    private Date finishTime;

    /**
     * 匹配的宠托师ID
     */
    private Long staffId;

    /**
     * 备注
     */
    private String orderRemark;

    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 修改时间
     */
    private Date gmtModified;


    public AddressInfoDto getAddressInfoDto() {
        return addressInfo == null ? null : JSON.parseObject(addressInfo, AddressInfoDto.class);
    }

    public List<PetInfoDto> getPetsDto() {
        return pets == null ? null : JSON.parseArray(pets, PetInfoDto.class);
    }


    //地址信息的类
    @Data
    public static class AddressInfoDto implements Serializable {
        private static final long serialVersionUID = -2968378334136484650L;
        /**
         * 联系人姓名
         */
        private String contactName;
        /**
         * 联系电话
         */
        private String contactPhone;
        /**
         * 省份
         */
        private String addressProvince;
        /**
         * 市
         */
        private String addressCity;
        /**
         * 区
         */
        private String addressDistrict;
        /**
         * 详细地址
         */
        private String detailAddress;
    }

    //宠物信息类
    @Data
    public static class PetInfoDto implements Serializable {
        private static final long serialVersionUID = -7865925733509690238L;
        /**
         * 宠物名字
         */
        private String petName;
        /**
         * 宠物种类，1:狗、2:猫
         */
        private Integer petSpecies;
        /**
         * 品种，如金毛、布偶等
         */
        private String petBreed;
        /**
         * 宠物重量
         */
        private Double petWeight;

    }
}