package cn.com.duiba.oto.oto.service.api.remoteservice.pet;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.pet.channel.PetChannelListItemDto;
import cn.com.duiba.oto.param.oto.pet.channel.RemotePetChannelCreateParam;
import cn.com.duiba.oto.param.oto.pet.channel.RemotePetChannelSearchParam;
import cn.com.duiba.oto.param.oto.pet.channel.RemotePetChannelToggleStatusParam;
import cn.com.duiba.oto.util.PageResult;

/**
 * 宠物渠道管理远程服务
 *
 * @author AI Assistant
 * @date 当前日期
 */
@AdvancedFeignClient
public interface RemotePetChannelService {

    /**
     * crm搜索渠道
     * @param param
     * @return
     */
    PageResult<PetChannelListItemDto> searchChannels(RemotePetChannelSearchParam param);

    /**
     * 创建渠道
     * @param param
     * @return
     * @throws BizException
     */
    boolean createChannel(RemotePetChannelCreateParam param) throws BizException;

    /**
     * 生成渠道二维码
     * @param id
     * @return
     * @throws BizException
     */
    String generateQrCode(Long id) throws BizException;

    /**
     * 切换渠道状态
     * @param param
     * @return
     * @throws BizException
     */
    boolean toggleChannelStatus(RemotePetChannelToggleStatusParam param) throws BizException;

    /**
     * 绑定渠道
     */
    boolean bindChannel(Long userId, Long channelId) throws BizException;
}