package cn.com.duiba.oto.oto.service.api.remoteservice.wx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.wx.wxmessage.wrapper.SingleWxMessageWrapperDto;

/**
 * Created by xiaotian on 2023-03-14.
 * 异步发送公众号消息
 */
@AdvancedFeignClient
public interface RemoteAsyncOaMessageSenderService {
    /**
     * 异步发送客服消息
     * 不入mq队列 优先发送
     * @param singleWxMessageWrapperDto 客服消息包装体
     */
    void sendCustomerMessage(SingleWxMessageWrapperDto singleWxMessageWrapperDto);

    /**
     * 异步发送模版消息
     * 不入mq队列 优先发送
     * @param singleWxMessageWrapperDto 模版消息包装体
     */
    void sendTemplateMessage(SingleWxMessageWrapperDto singleWxMessageWrapperDto);


    /**
     * 异步发送订阅消息
     * 不入mq队列 优先发送
     * <a href="https://developers.weixin.qq.com/miniprogram/dev/api-backend/open-api/subscribe-message/subscribeMessage.send.html">模版内容长度限制<a/>
     * @param singleWxMessageWrapperDto 消息包装体
     */
    void sendSubscribeMessage(SingleWxMessageWrapperDto singleWxMessageWrapperDto);
}
