/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.enums.pet;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public enum PetWashBaseEnum {
    SHORT_HAIR_CAT(1, 14800L, 8800L, "\u77ed\u6bdb\u732b"),
    LONG_HAIR_CAT(2, 16800L, 9800L, "\u957f\u6bdb\u732b"),
    SMALL_DOG(3, 8000L, 6600L, "\u5c0f\u578b\u72ac"),
    MEDIUM_DOG(4, 10800L, 8800L, "\u4e2d\u578b\u72ac"),
    BIG_DOG(5, 18800L, 15800L, "\u5927\u578b\u72ac");

    private static final Map<Integer, String> CUSTOMER_TYPE_MAP;
    private Integer code;
    private Long price;
    private Long firstPrice;
    private String desc;

    public Long getPrice() {
        if (SpringEnvironmentUtils.isProdEnv()) {
            return this.price;
        }
        return this.price / 1000L;
    }

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return "";
        }
        return CUSTOMER_TYPE_MAP.get(code);
    }

    public Integer getCode() {
        return this.code;
    }

    public Long getFirstPrice() {
        return this.firstPrice;
    }

    public String getDesc() {
        return this.desc;
    }

    private PetWashBaseEnum(Integer code, Long price, Long firstPrice, String desc) {
        this.code = code;
        this.price = price;
        this.firstPrice = firstPrice;
        this.desc = desc;
    }

    static {
        CUSTOMER_TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(PetWashBaseEnum.values()).collect(Collectors.toMap(PetWashBaseEnum::getCode, PetWashBaseEnum::getDesc, (v1, v2) -> v1)));
    }
}

